/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.json.config;

import java.util.HashMap;
import org.mule.runtime.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.runtime.module.json.validation.ValidateJsonSchemaMessageProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ValidateJsonSchemaMessageProcessorDefinitionParser
extends ChildDefinitionParser {
    private static final String SCHEMA_REDIRECTS_PROPERTY_NAME = "schemaRedirects";
    private static final String SCHEMA_REDIRECTS_ELEMENT_NAME = "schema-redirects";
    private static final String SCHEMA_REDIRECT_ELEMENT_NAME = "schema-redirect";
    private static final String FROM = "from";
    private static final String TO = "to";

    public ValidateJsonSchemaMessageProcessorDefinitionParser() {
        super("messageProcessor", ValidateJsonSchemaMessageProcessor.class);
        this.addIgnored(SCHEMA_REDIRECTS_PROPERTY_NAME);
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.parseChild(element, parserContext, builder);
        this.parseRedirects(element, builder);
    }

    private void parseRedirects(Element element, BeanDefinitionBuilder builder) {
        Element redirectsElement = DomUtils.getChildElementByTagName((Element)element, (String)SCHEMA_REDIRECTS_ELEMENT_NAME);
        if (redirectsElement != null) {
            HashMap<String, String> redirectMap = new HashMap<String, String>();
            for (Element redirect : DomUtils.getChildElementsByTagName((Element)redirectsElement, (String)SCHEMA_REDIRECT_ELEMENT_NAME)) {
                redirectMap.put(redirect.getAttribute(FROM), redirect.getAttribute(TO));
            }
            builder.addPropertyValue(SCHEMA_REDIRECTS_PROPERTY_NAME, redirectMap);
        }
    }
}

