/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.json.transformers.JsonMapperResolver;
import org.mule.module.json.transformers.JsonToObject;
import org.mule.module.json.transformers.ObjectToJson;
import org.mule.transformer.simple.ObjectToString;

public class JsonTransformerResolver
implements TransformerResolver,
MuleContextAware,
Disposable {
    public static final String JSON_MIME_TYPE = "application/json";
    protected final transient Log logger = LogFactory.getLog(JsonTransformerResolver.class);
    private MuleContext muleContext;
    private Map<String, Transformer> transformerCache = new WeakHashMap<String, Transformer>();
    private JsonMapperResolver resolver;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Transformer resolve(DataType<?> source, DataType<?> result) throws ResolverException {
        Object t = this.transformerCache.get(source.toString() + result.toString());
        if (t != null) {
            return t;
        }
        try {
            boolean marshal;
            Class annotatedType;
            ObjectMapper mapper = (ObjectMapper)this.getMapperResolver().resolve(ObjectMapper.class, source, result, this.muleContext);
            if (mapper == null) {
                return null;
            }
            if (this.getMapperResolver().getMatchingClasses().contains(result.getType())) {
                annotatedType = result.getType();
                source = source.cloneDataType();
                source.setMimeType(JSON_MIME_TYPE);
                marshal = false;
            } else if (this.getMapperResolver().getMatchingClasses().contains(source.getType())) {
                annotatedType = source.getType();
                result = result.cloneDataType();
                result.setMimeType(JSON_MIME_TYPE);
                marshal = true;
            } else {
                return null;
            }
            List ts = this.muleContext.getRegistry().lookupTransformers(source, result);
            if (ts.size() == 1 && !(ts.get(0) instanceof ObjectToString)) {
                t = (Transformer)ts.get(0);
            } else if (marshal) {
                ObjectToJson otj = new ObjectToJson();
                otj.setSourceClass(annotatedType);
                otj.setReturnDataType(result);
                otj.setMapper(mapper);
                this.muleContext.getRegistry().applyProcessorsAndLifecycle((Object)otj);
                t = otj;
            } else {
                JsonToObject jto = new JsonToObject();
                jto.setReturnDataType(result);
                jto.setMapper(mapper);
                this.muleContext.getRegistry().applyProcessorsAndLifecycle((Object)jto);
                t = jto;
            }
            this.transformerCache.put(source.toString() + result.toString(), (Transformer)t);
            return t;
        }
        catch (Exception e) {
            throw new ResolverException(CoreMessages.createStaticMessage((String)"Failed to unmarshal"), (Throwable)e);
        }
    }

    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
    }

    public void dispose() {
        this.transformerCache.clear();
    }

    protected JsonMapperResolver getMapperResolver() throws ResolverException {
        if (this.resolver == null) {
            try {
                this.resolver = (JsonMapperResolver)((Object)this.muleContext.getRegistry().lookupObject(JsonMapperResolver.class));
            }
            catch (RegistrationException e) {
                throw new ResolverException(e.getI18nMessage(), (Throwable)e);
            }
        }
        return this.resolver;
    }
}

