/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.json.JsonData;
import org.mule.util.NumberUtils;

public class JsonExpressionEvaluator
implements ExpressionEvaluator {
    protected final transient Log logger = LogFactory.getLog(JsonExpressionEvaluator.class);

    public Object evaluate(String expression, MuleMessage message) {
        String compareTo = null;
        boolean not = false;
        int start = expression.lastIndexOf("/");
        if (start == -1) {
            start = 0;
        }
        int i = 0;
        i = expression.indexOf("!=", start);
        if (i > -1) {
            compareTo = expression.substring(i + 2, expression.length()).trim();
            expression = expression.substring(0, i).trim();
            not = true;
        } else {
            i = expression.indexOf("=", start);
            if (i > -1) {
                compareTo = expression.substring(i + 1, expression.length()).trim();
                expression = expression.substring(0, i).trim();
            }
        }
        try {
            String json = message.getPayloadAsString();
            JsonData data = new JsonData(json);
            try {
                Object result = data.get(expression);
                if (compareTo != null) {
                    if (compareTo.equalsIgnoreCase("null")) {
                        boolean answer;
                        boolean bl = answer = result == null;
                        return not ? !answer : answer;
                    }
                    if (result instanceof Number && NumberUtils.isDigits((String)compareTo)) {
                        boolean answer = NumberUtils.createNumber((String)compareTo).equals(result);
                        return not ? !answer : answer;
                    }
                    if (result instanceof Boolean && (compareTo.equalsIgnoreCase("true") || compareTo.equalsIgnoreCase("false"))) {
                        boolean answer = result.equals(Boolean.valueOf(compareTo));
                        return not ? !answer : answer;
                    }
                    boolean answer = compareTo.equals(result);
                    return not ? !answer : answer;
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                if (compareTo == null) {
                    this.logger.debug((Object)("returning null for json expression: " + expression + ": " + e.getMessage()));
                    return null;
                }
                return compareTo.equalsIgnoreCase("null") & !not;
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction((String)(this.getName() + ":" + expression)), (Throwable)e);
        }
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    public String getName() {
        return "json";
    }
}

