/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.UnsupportedEncodingException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.module.json.util.JsonUtils;
import org.mule.transformer.AbstractTransformer;
import org.mule.transport.NullPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonToXml
extends AbstractTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonToXml.class);
    public static final String ELEMENT_NAME_OBJECT = "o";
    public static final String ELEMENT_NAME_ARRAY = "a";
    public static final String ELEMENT_NAME_VALUE = "e";
    public static final String ELEMENT_NAME_ARRAY_ELEMENT = "e";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"${encoding}\"?>";
    protected String objectElementName = "o";
    protected String arrayElementName = "a";
    protected String valueElementName = "e";

    public JsonToXml() {
        this.registerSourceType(JSON.class);
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(Object.class);
        this.setReturnClass(String.class);
    }

    public String getObjectElementName() {
        return this.objectElementName;
    }

    public void setObjectElementName(String objectElementName) {
        this.objectElementName = objectElementName;
    }

    public String getArrayElementName() {
        return this.arrayElementName;
    }

    public void setArrayElementName(String arrayElementName) {
        this.arrayElementName = arrayElementName;
    }

    public String getValueElementName() {
        return this.valueElementName;
    }

    public void setValueElementName(String valueElementName) {
        this.valueElementName = valueElementName;
    }

    public boolean isAcceptMuleMessage() {
        return this.sourceTypes.contains(MuleMessage.class);
    }

    public void setAcceptMuleMessage(boolean value) {
        if (value) {
            this.registerSourceType(MuleMessage.class);
        } else {
            this.unregisterSourceType(MuleMessage.class);
        }
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        String returnValue = null;
        JSON json = null;
        if (src == null || src instanceof NullPayload) {
            return this.getStringOfEncoding(this.getXmlDeclaration(encoding) + "\n" + this.getXmlOfNull(), encoding);
        }
        if (!(src instanceof JSON) && !(src instanceof String)) {
            src = src.toString();
        }
        if (src instanceof String) {
            String jsonString = (String)src;
            if (JsonUtils.isBoolean(jsonString) || JsonUtils.isString(jsonString) || JsonUtils.isNumber(jsonString)) {
                return this.getStringOfEncoding(this.getXmlDeclaration(encoding) + "\n" + this.getXmlOfCommonValue(jsonString), encoding);
            }
            if (JsonUtils.isArray(jsonString)) {
                json = JSONArray.fromObject((Object)jsonString);
            } else if (JsonUtils.isObject(jsonString)) {
                json = JSONObject.fromObject((Object)jsonString);
            } else {
                throw new IllegalArgumentException("Could not recognize type of '" + jsonString + "'");
            }
        }
        if (json != null || src instanceof JSON) {
            if (json == null) {
                json = (JSON)src;
            }
            returnValue = this.getXmlOfJson(json, encoding);
        }
        return returnValue;
    }

    protected String getStringOfEncoding(String string, String encoding) {
        String returnValue;
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        try {
            returnValue = new String(string.getBytes(encoding));
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.warn("Unsupported encoding specified '" + encoding + "', could not handle and thus returning original string");
            returnValue = string;
        }
        return returnValue;
    }

    protected String getXmlDeclaration(String encoding) {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        String returnValue = XML_DECLARATION;
        returnValue = StringUtils.replace((String)returnValue, (String)"${encoding}", (String)encoding);
        return returnValue;
    }

    protected String getXmlOfNull() {
        return "<" + this.getValueElementName() + "/>";
    }

    protected String getXmlOfCommonValue(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + this.getValueElementName() + " type=\"");
        if (JsonUtils.isString(value)) {
            sb.append("string");
        } else if (JsonUtils.isBoolean(value)) {
            sb.append("boolean");
        } else if (JsonUtils.isNumber(value)) {
            sb.append("number");
        } else {
            sb.append("unknown");
        }
        sb.append("\">");
        sb.append(value);
        sb.append("</" + this.getValueElementName() + ">");
        return sb.toString();
    }

    protected String getXmlOfJson(JSON json, String encoding) {
        XMLSerializer xmlSerializer = this.newXmlSerializer();
        return xmlSerializer.write(json, encoding);
    }

    protected XMLSerializer newXmlSerializer() {
        XMLSerializer xmlSerializer = new XMLSerializer();
        xmlSerializer.setObjectName(this.getObjectElementName());
        xmlSerializer.setArrayName(this.getArrayElementName());
        xmlSerializer.setElementName(this.getValueElementName());
        return xmlSerializer;
    }
}

