/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonUtils {
    protected static final Log logger = LogFactory.getLog(JsonUtils.class);
    public static final String PATTERN_ARRAY = "\\[(.*)\\]";
    public static final String PATTERN_OBJECT = "\\{(.*)\\}";
    public static final String PATTERN_STRING = "(\"|')(.*)(\"|')";

    public static Object[] convertJsonToArray(String jsonString, JsonConfig config) {
        config.setArrayMode(2);
        JSON json = JSONSerializer.toJSON((Object)jsonString, (JsonConfig)config);
        if (config.getEnclosedType() != null && config.getEnclosedType().isArray()) {
            Class<?> c = config.getEnclosedType().getComponentType();
            return (Object[])JSONArray.toArray((JSONArray)((JSONArray)json), c);
        }
        return (Object[])JSONArray.toArray((JSONArray)((JSONArray)json), (JsonConfig)config);
    }

    public static Object convertJsonToBean(String jsonString, JsonConfig config, Class returnType, Map classMapping) {
        if (classMapping == null) {
            classMapping = Collections.EMPTY_MAP;
        }
        JSON json = JSONSerializer.toJSON((Object)jsonString, (JsonConfig)config);
        Object bean = JSONObject.toBean((JSONObject)((JSONObject)json), (Class)returnType, (Map)classMapping);
        return bean;
    }

    public static BigDecimal convertJsonToNumber(String jsonString) {
        return NumberUtils.createBigDecimal((String)jsonString);
    }

    public static BigDecimal[] convertJsonToNumberArray(String jsonString, JsonConfig config) {
        Object[] objs = JsonUtils.convertJsonToArray(jsonString, config);
        BigDecimal[] bds = new BigDecimal[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            bds[i] = new BigDecimal(objs[i].toString());
        }
        return bds;
    }

    public static String convertJsonToString(String jsonString) {
        Pattern pattern = Pattern.compile("^(\"|')(.*)(\"|')$");
        Matcher matcher = pattern.matcher(jsonString);
        if (matcher.matches()) {
            jsonString = matcher.group(2);
        }
        return jsonString;
    }

    public static Object convertJsonToJavaObject(String jsonString, JsonConfig config, Class returnType, Map mappings) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converting jsonString to Java object: jsonString=" + jsonString + ", config=" + config));
        }
        Object returnValue = null;
        if (JsonUtils.isArray(jsonString)) {
            if (List.class.isAssignableFrom(config.getEnclosedType())) {
                JSON json = JSONSerializer.toJSON((Object)jsonString, (JsonConfig)config);
                returnValue = JSONArray.toCollection((JSONArray)((JSONArray)json), (JsonConfig)config);
            } else if (Set.class.isAssignableFrom(config.getEnclosedType())) {
                config.setCollectionType(config.getEnclosedType());
                JSON json = JSONSerializer.toJSON((Object)jsonString, (JsonConfig)config);
                returnValue = JSONArray.toCollection((JSONArray)((JSONArray)json), (JsonConfig)config);
            } else {
                returnValue = JsonUtils.convertJsonToArray(jsonString, config);
            }
        } else if (JsonUtils.isObject(jsonString)) {
            returnValue = JsonUtils.convertJsonToBean(jsonString, config, returnType, mappings);
        } else if (JsonUtils.isBoolean(jsonString)) {
            returnValue = Boolean.valueOf(jsonString);
        } else if (JsonUtils.isNumber(jsonString)) {
            returnValue = JsonUtils.convertJsonToNumber(jsonString);
        } else if (JsonUtils.isNull(jsonString)) {
            returnValue = null;
        } else if (JsonUtils.isString(jsonString)) {
            returnValue = JsonUtils.convertJsonToString(jsonString);
        } else {
            throw new IllegalArgumentException("Provided JSON string matches neither of the known type: jsonString=" + jsonString);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converted and returning value '" + returnValue + "', of type '" + (returnValue != null ? returnValue.getClass().getName() : null) + "'"));
        }
        return returnValue;
    }

    public static String convertJavaObjectToJson(Object object, JsonConfig config) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof Boolean || object instanceof Number) {
            return object.toString();
        }
        return JSONSerializer.toJSON((Object)object, (JsonConfig)config).toString();
    }

    public static boolean isArray(String jsonString) {
        return JsonUtils.isMatched(jsonString.trim(), "^\\[(.*)\\]$");
    }

    public static boolean isBoolean(String jsonString) {
        return jsonString.equals("true") || jsonString.equals("false");
    }

    public static boolean isNull(String jsonString) {
        return jsonString.equals("null");
    }

    public static boolean isNumber(String jsonString) {
        return NumberUtils.isNumber((String)jsonString);
    }

    public static boolean isObject(String jsonString) {
        return JsonUtils.isMatched(jsonString.trim(), "^\\{(.*)\\}$");
    }

    public static boolean isString(String jsonString) {
        return !JsonUtils.isNumber(jsonString) && !JsonUtils.isBoolean(jsonString) && !JsonUtils.isNull(jsonString) && !JsonUtils.isArray(jsonString) && !JsonUtils.isObject(jsonString);
    }

    private static boolean isMatched(String string, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static Object getObjectFromDynaBean(Class clazz, DynaBean dynaBean) throws Exception {
        Object returnValue = null;
        if (clazz == null || dynaBean == null) {
            throw new NullPointerException("Class instance or DynaBean instance should not be null, clazz=" + clazz + ", dynaBean=" + dynaBean);
        }
        returnValue = clazz.newInstance();
        BeanUtils.copyProperties(returnValue, (Object)dynaBean);
        return returnValue;
    }

    public static Object getObjectFromDynaBean(String className, DynaBean dynaBean) throws Exception {
        Class<?> clazz = Class.forName(className);
        return JsonUtils.getObjectFromDynaBean(clazz, dynaBean);
    }

    public static Object getObjectFromJsonString(String jsonString, JsonConfig config, Class returnClass) throws Exception {
        Object object = JsonUtils.convertJsonToJavaObject(jsonString, config, returnClass, null);
        Object returnValue = object instanceof DynaBean ? JsonUtils.getObjectFromDynaBean(returnClass, (DynaBean)object) : object;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning value of type " + (returnValue == null ? null : returnValue.getClass())));
        }
        return returnValue;
    }
}

