/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private final ArrayList pool = new ArrayList();
    private int poolSize;
    private int checkedOut = 0;
    private boolean autocommit;
    private Driver driver;
    private static final Logger log = LoggerFactory.getLogger(SimpleConnectionProvider.class);

    public void configure(Properties props) throws HibernateException {
        String driverClass = props.getProperty("hibernate.connection.driver_class");
        this.poolSize = SimpleConnectionProvider.getInt("hibernate.connection.pool_size", props, 20);
        log.info("Using Hibernate built-in connection pool (not for production use!)");
        log.info("Hibernate connection pool size: " + this.poolSize);
        this.autocommit = SimpleConnectionProvider.getBoolean("hibernate.connection.autocommit", props);
        log.info("autocommit mode: " + this.autocommit);
        this.isolation = SimpleConnectionProvider.getInteger("hibernate.connection.isolation", props);
        if (this.isolation != null) {
            log.info("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation));
        }
        if (driverClass == null) {
            log.warn("no JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                this.driver = (Driver)Class.forName(driverClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                try {
                    this.driver = (Driver)ReflectHelper.classForName((String)driverClass).newInstance();
                }
                catch (Exception e1) {
                    log.error(e1.getMessage());
                    throw new HibernateException((Throwable)e1);
                }
            }
        }
        this.url = props.getProperty("hibernate.connection.url");
        if (this.url == null) {
            String msg = "JDBC URL was not specified by property hibernate.connection.url";
            log.error(msg);
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderFactory.getConnectionProperties((Properties)props);
        log.info("using driver: " + driverClass + " at URL: " + this.url);
        if (log.isDebugEnabled()) {
            log.info("connection properties: " + this.connectionProps);
        } else if (log.isInfoEnabled()) {
            log.info("connection properties: " + SimpleConnectionProvider.maskOut(this.connectionProps, "password"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace("total checked-out connections: " + this.checkedOut);
        }
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            if (!this.pool.isEmpty()) {
                int last = this.pool.size() - 1;
                if (log.isTraceEnabled()) {
                    log.trace("using pooled JDBC connection, pool size: " + last);
                    ++this.checkedOut;
                }
                Connection pooled = (Connection)this.pool.remove(last);
                if (this.isolation != null) {
                    pooled.setTransactionIsolation(this.isolation);
                }
                if (pooled.getAutoCommit() != this.autocommit) {
                    pooled.setAutoCommit(this.autocommit);
                }
                return pooled;
            }
        }
        log.debug("opening new JDBC connection");
        Connection conn = this.driver.connect(this.url, this.connectionProps);
        if (this.isolation != null) {
            conn.setTransactionIsolation(this.isolation);
        }
        if (conn.getAutoCommit() != this.autocommit) {
            conn.setAutoCommit(this.autocommit);
        }
        if (log.isDebugEnabled()) {
            log.debug("created connection to: " + this.url + ", Isolation Level: " + conn.getTransactionIsolation());
        }
        if (log.isTraceEnabled()) {
            ++this.checkedOut;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        if (log.isDebugEnabled()) {
            --this.checkedOut;
        }
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            int currentSize = this.pool.size();
            if (currentSize < this.poolSize) {
                if (log.isTraceEnabled()) {
                    log.trace("returning connection to pool, pool size: " + (currentSize + 1));
                }
                this.pool.add(conn);
                return;
            }
        }
        log.debug("closing JDBC connection");
        conn.close();
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        log.info("cleaning up connection pool: " + this.url);
        Iterator iter = this.pool.iterator();
        while (iter.hasNext()) {
            try {
                ((Connection)iter.next()).close();
            }
            catch (SQLException sqle) {
                log.warn("problem closing pooled connection", (Throwable)sqle);
            }
        }
        this.pool.clear();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public static boolean getBoolean(String name, Map values) {
        return SimpleConnectionProvider.getBoolean(name, values, false);
    }

    public static boolean getBoolean(String name, Map values, boolean defaultValue) {
        Object value = values.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (Boolean.class.isInstance(value)) {
            return (Boolean)value;
        }
        if (String.class.isInstance(value)) {
            return Boolean.parseBoolean((String)value);
        }
        throw new HibernateException("Could not determine how to handle configuration value [name=" + name + ", value=" + value + "] as boolean");
    }

    public static int getInt(String name, Map values, int defaultValue) {
        Object value = values.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (Integer.class.isInstance(value)) {
            return (Integer)value;
        }
        if (String.class.isInstance(value)) {
            return Integer.parseInt((String)value);
        }
        throw new HibernateException("Could not determine how to handle configuration value [name=" + name + ", value=" + value + "(" + value.getClass().getName() + ")] as int");
    }

    public static Integer getInteger(String name, Map values) {
        Object value = values.get(name);
        if (value == null) {
            return null;
        }
        if (Integer.class.isInstance(value)) {
            return (Integer)value;
        }
        if (String.class.isInstance(value)) {
            return Integer.valueOf((String)value);
        }
        throw new HibernateException("Could not determine how to handle configuration value [name=" + name + ", value=" + value + "(" + value.getClass().getName() + ")] as Integer");
    }

    public static Properties maskOut(Properties props, String key) {
        Properties clone = (Properties)props.clone();
        if (clone.get(key) != null) {
            clone.setProperty(key, "****");
        }
        return clone;
    }
}

