/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.jaas.filters;

import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.security.Authentication;
import org.mule.runtime.core.api.security.Credentials;
import org.mule.runtime.core.api.security.CredentialsAccessor;
import org.mule.runtime.core.api.security.CredentialsNotSetException;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.SecurityException;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.api.security.UnauthorisedException;
import org.mule.runtime.core.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.security.AbstractOperationSecurityFilter;
import org.mule.runtime.core.security.MuleCredentials;
import org.mule.runtime.core.security.MuleHeaderCredentialsAccessor;
import org.mule.runtime.module.jaas.JaasAuthentication;

public class JaasSecurityFilter
extends AbstractOperationSecurityFilter {
    public JaasSecurityFilter() {
        this.setCredentialsAccessor((CredentialsAccessor)new MuleHeaderCredentialsAccessor());
    }

    protected final Event authenticateInbound(Event event) throws SecurityException, CryptoFailureException, EncryptionStrategyNotFoundException, UnknownAuthenticationTypeException {
        Authentication authResult;
        String userHeader = (String)((Object)this.getCredentialsAccessor().getCredentials(event));
        if (userHeader == null) {
            throw new CredentialsNotSetException(event, event.getSession().getSecurityContext(), (SecurityFilter)this);
        }
        MuleCredentials user = new MuleCredentials(userHeader, this.getSecurityManager());
        JaasAuthentication authentication = new JaasAuthentication((Credentials)user);
        authentication.setEvent(event);
        try {
            authResult = this.getSecurityManager().authenticate((Authentication)authentication);
        }
        catch (SecurityException se) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Security Exception raised. Authentication request for user: " + user.getUsername() + " failed: " + se.toString());
            }
            throw se;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Authentication request for user: " + user.getUsername() + " failed: " + e.toString());
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser((Object)user.getUsername()), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authentication success: " + authResult.toString());
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        context.setAuthentication(authResult);
        event.getSession().setSecurityContext(context);
        return event;
    }

    protected void doInitialise() throws InitialisationException {
    }
}

