/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.service.http.api.HttpHeaders;
import org.mule.service.http.api.domain.ParameterMap;
import org.mule.service.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.service.http.api.domain.entity.EmptyHttpEntity;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestFactory {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestFactory.class);
    public static final List<String> DEFAULT_EMPTY_BODY_METHODS = Lists.newArrayList((Object[])new String[]{"GET", "HEAD", "OPTIONS"});
    private static final String APPLICATION_JAVA = "application/java";
    private final String uri;
    private final String method;
    private final HttpRequesterCookieConfig config;
    private final HttpStreamingType streamingMode;
    private final HttpSendBodyMode sendBodyMode;
    private final TransformationService transformationService;

    public HttpRequestFactory(HttpRequesterCookieConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, TransformationService transformationService) {
        this.config = config;
        this.uri = uri;
        this.method = method;
        this.streamingMode = streamingMode;
        this.sendBodyMode = sendBodyMode;
        this.transformationService = transformationService;
    }

    public HttpRequest create(HttpRequesterRequestBuilder requestBuilder, HttpAuthentication authentication, MuleContext muleContext) {
        HttpRequestBuilder builder = HttpRequest.builder();
        builder.setUri(this.uri);
        builder.setMethod(this.method);
        builder.setHeaders(this.toParameterMap(requestBuilder.getHeaders()));
        builder.setQueryParams(this.toParameterMap(requestBuilder.getQueryParams()));
        MediaType mediaType = requestBuilder.getBody().getDataType().getMediaType();
        if (!builder.getHeaderValue("Content-Type").isPresent() && !MediaType.ANY.matches(mediaType)) {
            builder.addHeader("Content-Type", mediaType.toRfcString());
        }
        if (this.config.isEnableCookies()) {
            try {
                Map<String, List<String>> headers = this.config.getCookieManager().get(URI.create(this.uri), Collections.emptyMap());
                List<String> cookies = headers.get("Cookie");
                if (cookies != null) {
                    for (String cookie : cookies) {
                        builder.addHeader("Cookie", cookie);
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Error reading cookies for URI " + this.uri, (Throwable)e);
            }
        }
        try {
            builder.setEntity(this.createRequestEntity(builder, this.method, muleContext, requestBuilder.getBody().getValue(), mediaType));
        }
        catch (TransformerException e) {
            throw new ModuleException((Throwable)e, (ErrorTypeDefinition)HttpError.TRANSFORMATION);
        }
        if (authentication != null) {
            try {
                authentication.authenticate(builder);
            }
            catch (MuleException e) {
                throw new ModuleException((Throwable)e, (ErrorTypeDefinition)HttpError.SECURITY);
            }
        }
        return builder.build();
    }

    private ParameterMap toParameterMap(Map<String, String> map) {
        ParameterMap parameterMap = new ParameterMap();
        map.forEach((arg_0, arg_1) -> ((ParameterMap)parameterMap).put(arg_0, arg_1));
        return parameterMap;
    }

    private HttpEntity createRequestEntity(HttpRequestBuilder requestBuilder, String resolvedMethod, MuleContext muleContext, Object body, MediaType mediaType) throws TransformerException {
        Object entity = this.isEmptyBody(body, resolvedMethod) ? new EmptyHttpEntity() : this.createRequestEntityFromPayload(requestBuilder, body, muleContext, mediaType);
        return entity;
    }

    private boolean isEmptyBody(Object body, String method) {
        boolean emptyBody;
        if (body == null) {
            emptyBody = true;
        } else {
            emptyBody = DEFAULT_EMPTY_BODY_METHODS.contains(method);
            if (this.sendBodyMode != HttpSendBodyMode.AUTO) {
                emptyBody = this.sendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        return emptyBody;
    }

    private HttpEntity createRequestEntityFromPayload(HttpRequestBuilder requestBuilder, Object payload, MuleContext muleContext, MediaType mediaType) throws TransformerException {
        if (payload instanceof MultiPartPayload) {
            Transformer objectToByteArray = muleContext.getRegistry().lookupTransformer(DataType.OBJECT, DataType.BYTE_ARRAY);
            return new MultipartHttpEntity(HttpPartDataSource.createFrom((MultiPartPayload)payload, objectToByteArray));
        }
        if (this.doStreaming(requestBuilder, payload)) {
            if (payload instanceof InputStream) {
                return new InputStreamHttpEntity((InputStream)payload);
            }
            return new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(this.getMessageAsBytes(payload)));
        }
        Optional contentType = requestBuilder.getHeaderValue("Content-Type");
        if ((!contentType.isPresent() || ((String)contentType.get()).startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString()) || ((String)contentType.get()).startsWith(APPLICATION_JAVA)) && payload instanceof Map) {
            String body = HttpEncoderDecoderUtils.encodeString((Map)((Map)payload), (Charset)mediaType.getCharset().orElse(SystemUtils.getDefaultEncoding((MuleContext)muleContext)));
            requestBuilder.addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
            return new ByteArrayHttpEntity(body.getBytes());
        }
        return new ByteArrayHttpEntity(this.getMessageAsBytes(payload));
    }

    private byte[] getMessageAsBytes(Object payload) throws TransformerException {
        return (byte[])this.transformationService.transform(InternalMessage.of((Object)payload), DataType.BYTE_ARRAY).getPayload().getValue();
    }

    private boolean doStreaming(HttpRequestBuilder requestBuilder, Object payload) {
        Optional transferEncodingHeader = requestBuilder.getHeaderValue("Transfer-Encoding");
        Optional contentLengthHeader = requestBuilder.getHeaderValue("Content-Length");
        if (this.streamingMode == HttpStreamingType.AUTO) {
            if (contentLengthHeader.isPresent()) {
                if (transferEncodingHeader.isPresent()) {
                    requestBuilder.removeHeader("Transfer-Encoding");
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.");
                    }
                }
                return false;
            }
            if (!transferEncodingHeader.isPresent() || !((String)transferEncodingHeader.get()).equalsIgnoreCase("chunked")) {
                return payload instanceof InputStream;
            }
            return true;
        }
        if (this.streamingMode == HttpStreamingType.ALWAYS) {
            if (contentLengthHeader != null) {
                requestBuilder.removeHeader("Content-Length");
                if (logger.isDebugEnabled()) {
                    logger.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS");
                }
            }
            if (transferEncodingHeader.isPresent() && !((String)transferEncodingHeader.get()).equalsIgnoreCase("chunked")) {
                requestBuilder.removeHeader("Transfer-Encoding");
                if (logger.isDebugEnabled()) {
                    logger.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is NEVER", (Object)transferEncodingHeader);
                }
            }
            return true;
        }
        if (transferEncodingHeader != null) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (logger.isDebugEnabled()) {
                logger.debug("Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER");
            }
        }
        return false;
    }
}

