/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpListenerResponseAttributes;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.error.HttpMessageParsingException;
import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.internal.HttpListenerMetadataResolver;
import org.mule.extension.http.internal.listener.ConfigurationOverrides;
import org.mule.extension.http.internal.listener.HttpListenerResponseSender;
import org.mule.extension.http.internal.listener.HttpRequestToResult;
import org.mule.extension.http.internal.listener.HttpResponseContext;
import org.mule.extension.http.internal.listener.HttpResponseFactory;
import org.mule.extension.http.internal.listener.server.HttpListenerConfig;
import org.mule.extension.http.internal.listener.server.ModuleRequestHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.config.ExceptionHelper;
import org.mule.runtime.core.exception.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.core.exception.ErrorTypeMatcher;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.listener.ListenerPath;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.domain.HttpProtocol;
import org.mule.service.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.server.HttpServer;
import org.mule.service.http.api.server.RequestHandler;
import org.mule.service.http.api.server.RequestHandlerManager;
import org.mule.service.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="listener")
@MetadataScope(outputResolver=HttpListenerMetadataResolver.class)
@EmitsResponse
public class HttpListener
extends Source<Object, HttpRequestAttributes> {
    public static final String HTTP_NAMESPACE = "httpn";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListener.class);
    private static final String SERVER_PROBLEM = "Server encountered a problem";
    private static final String ERROR_RESPONSE_SETTINGS = "Error Response Settings";
    private static final String RESPONSE_CONTEXT = "responseContext";
    @Inject
    private MuleContext muleContext;
    @UseConfig
    private HttpListenerConfig config;
    @Connection
    private HttpServer server;
    @Parameter
    @Placement(order=1)
    private String path;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(order=2)
    private String allowedMethods;
    @ParameterGroup(name="Configuration Overrides")
    private ConfigurationOverrides configurationOverrides;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="AUTO")
    @Placement(tab="Advanced")
    private HttpStreamingType responseStreamingMode;
    private HttpListenerResponseSender responseSender;
    private ListenerPath listenerPath;
    private RequestHandlerManager requestHandlerManager;
    private HttpResponseFactory responseFactory;
    private ErrorTypeMatcher knownErrors;
    private Boolean parseRequest;
    private Class interpretedAttributes;

    @OnSuccess
    public void onSuccess(@org.mule.runtime.extension.api.annotation.param.Optional @Placement(tab="Response Settings") @NullSafe HttpListenerResponseBuilder response, SourceCallbackContext callbackContext) throws Exception {
        HttpResponseContext context = (HttpResponseContext)callbackContext.getVariable(RESPONSE_CONTEXT);
        this.responseSender.sendResponse(context, response);
    }

    @OnError
    public void onError(@org.mule.runtime.extension.api.annotation.param.Optional @Placement(tab="Error Response Settings") @NullSafe HttpListenerResponseBuilder errorResponse, SourceCallbackContext callbackContext, Error error) {
        HttpResponse response;
        HttpResponseBuilder failureResponseBuilder = this.createFailureResponseBuilder(error, errorResponse);
        if (errorResponse.getBody() == null || errorResponse.getBody().getValue() == null) {
            errorResponse.setBody((TypedValue<Object>)new TypedValue((Object)error.getCause().getMessage(), DataType.STRING));
        }
        HttpResponseContext context = (HttpResponseContext)callbackContext.getVariable(RESPONSE_CONTEXT);
        try {
            response = this.responseFactory.create(failureResponseBuilder, errorResponse, context.isSupportStreaming());
        }
        catch (Exception e) {
            response = this.buildErrorResponse();
        }
        HttpResponseReadyCallback responseCallback = context.getResponseCallback();
        responseCallback.responseReady(response, this.getResponseFailureCallback(responseCallback));
    }

    private HttpResponseBuilder createFailureResponseBuilder(Error error, HttpListenerResponseBuilder errorResponse) {
        HttpResponseBuilder failureResponseBuilder;
        if (this.hasCustomResponse(Optional.ofNullable(error))) {
            Message errorMessage = error.getErrorMessage();
            HttpResponseAttributes attributes = (HttpResponseAttributes)errorMessage.getAttributes();
            failureResponseBuilder = HttpResponse.builder().setStatusCode(Integer.valueOf(attributes.getStatusCode())).setReasonPhrase(attributes.getReasonPhrase());
            attributes.getHeaders().forEach((arg_0, arg_1) -> ((HttpResponseBuilder)failureResponseBuilder).addHeader(arg_0, arg_1));
            if (errorResponse.getBody().getValue() == null) {
                errorResponse.setBody((TypedValue<Object>)errorMessage.getPayload());
            }
        } else {
            failureResponseBuilder = error != null ? this.createDefaultFailureResponseBuilder(error) : HttpResponse.builder();
        }
        return failureResponseBuilder;
    }

    public void onStart(SourceCallback<Object, HttpRequestAttributes> sourceCallback) throws MuleException {
        this.path = HttpParser.sanitizePathWithStartSlash(this.path);
        this.listenerPath = this.config.getFullListenerPath(this.path);
        this.path = this.listenerPath.getResolvedPath();
        this.responseFactory = new HttpResponseFactory(this.responseStreamingMode, this.muleContext.getTransformationService());
        this.responseSender = new HttpListenerResponseSender(this.responseFactory);
        LifecycleUtils.startIfNeeded((Object)this.responseFactory);
        this.validatePath();
        this.parseRequest = this.config.resolveParseRequest(this.configurationOverrides.getParseRequest());
        this.interpretedAttributes = this.config.resolveInterpretRequestErrors(this.configurationOverrides.getInterpretRequestErrors()) != false ? HttpResponseAttributes.class : HttpListenerResponseAttributes.class;
        try {
            this.requestHandlerManager = this.allowedMethods != null ? this.server.addRequestHandler(Arrays.asList(this.extractAllowedMethods()), this.path, this.getRequestHandler(sourceCallback)) : this.server.addRequestHandler(this.path, this.getRequestHandler(sourceCallback));
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        this.knownErrors = new DisjunctiveErrorTypeMatcher(this.createErrorMatcherList(this.muleContext.getErrorTypeRepository()));
        this.requestHandlerManager.start();
    }

    private List<ErrorTypeMatcher> createErrorMatcherList(ErrorTypeRepository errorTypeRepository) {
        LinkedList<ErrorTypeMatcher> matchers = new LinkedList<ErrorTypeMatcher>();
        matchers.add((ErrorTypeMatcher)new SingleErrorTypeMatcher((ErrorType)errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.SECURITY).get()));
        matchers.add((ErrorTypeMatcher)new SingleErrorTypeMatcher((ErrorType)errorTypeRepository.lookupErrorType(ComponentIdentifier.builder().withNamespace(HTTP_NAMESPACE.toUpperCase()).withName(HttpError.RESPONSE_VALIDATION.name()).build()).get()));
        return matchers;
    }

    public void onStop() {
        if (this.requestHandlerManager != null) {
            this.requestHandlerManager.stop();
            this.requestHandlerManager.dispose();
        }
    }

    private RequestHandler getRequestHandler(final SourceCallback<Object, HttpRequestAttributes> sourceCallback) {
        return new ModuleRequestHandler(){

            @Override
            public Result<Object, HttpRequestAttributes> createResult(HttpRequestContext requestContext) throws HttpMessageParsingException {
                return HttpListener.this.createResult(requestContext);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                try {
                    HttpResponseContext responseContext = new HttpResponseContext();
                    String httpVersion = requestContext.getRequest().getProtocol().asString();
                    responseContext.setHttpVersion(httpVersion);
                    responseContext.setSupportStreaming(HttpListener.this.supportsTransferEncoding(httpVersion));
                    responseContext.setResponseCallback(responseCallback);
                    SourceCallbackContext context = sourceCallback.createContext();
                    context.addVariable(HttpListener.RESPONSE_CONTEXT, (Object)responseContext);
                    sourceCallback.handle(this.createResult(requestContext), context);
                }
                catch (IllegalArgumentException | HttpMessageParsingException e) {
                    LOGGER.warn("Exception occurred parsing request:", (Throwable)e);
                    this.sendErrorResponse(HttpConstants.HttpStatus.BAD_REQUEST, ((Throwable)e).getMessage(), responseCallback);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Exception occurred processing request:", (Throwable)e);
                    this.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, HttpListener.SERVER_PROBLEM, responseCallback);
                }
                finally {
                    Event.setCurrentEvent(null);
                }
            }

            private void sendErrorResponse(final HttpConstants.HttpStatus status, String message, HttpResponseReadyCallback responseCallback) {
                byte[] responseData = message.getBytes();
                responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().setStatusCode(Integer.valueOf(status.getStatusCode())).setReasonPhrase(status.getReasonPhrase()).setEntity((HttpEntity)new ByteArrayHttpEntity(responseData))).addHeader("Content-Length", Integer.toString(responseData.length))).build(), new ResponseStatusCallback(){

                    public void responseSendFailure(Throwable exception) {
                        LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Exception thrown", exception);
                        }
                    }

                    public void responseSendSuccessfully() {
                    }
                });
            }
        };
    }

    private boolean hasCustomResponse(Optional<Error> error) {
        return error.isPresent() && this.knownErrors.match(error.get().getErrorType()) && error.get().getErrorMessage() != null && this.interpretedAttributes.isInstance(error.get().getErrorMessage().getAttributes());
    }

    private HttpResponseBuilder createDefaultFailureResponseBuilder(Error error) {
        if (this.knownErrors.match(error.getErrorType())) {
            Optional<HttpConstants.HttpStatus> status;
            HttpError httpError = null;
            try {
                httpError = HttpError.valueOf(error.getErrorType().getIdentifier());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (httpError != null && (status = HttpError.getHttpStatus(httpError)).isPresent()) {
                return HttpResponse.builder().setStatusCode(Integer.valueOf(status.get().getStatusCode())).setReasonPhrase(status.get().getReasonPhrase());
            }
        }
        Throwable throwable = error.getCause();
        String exceptionStatusCode = ExceptionHelper.getTransportErrorMapping((String)HttpConstants.Protocols.HTTP.getScheme(), throwable.getClass(), (MuleContext)this.muleContext);
        Integer statusCodeFromException = exceptionStatusCode != null ? Integer.valueOf(exceptionStatusCode) : 500;
        String reasonPhraseFromException = HttpConstants.HttpStatus.getReasonPhraseForStatusCode((int)statusCodeFromException);
        return HttpResponse.builder().setStatusCode(statusCodeFromException).setReasonPhrase(reasonPhraseFromException != null ? reasonPhraseFromException : throwable.getMessage());
    }

    private Result<Object, HttpRequestAttributes> createResult(HttpRequestContext requestContext) throws HttpMessageParsingException {
        return HttpRequestToResult.transform(requestContext, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext), this.parseRequest, this.listenerPath);
    }

    protected HttpResponse buildResponse(HttpListenerResponseBuilder listenerResponseBuilder, boolean supportStreaming) throws Exception {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        return this.doBuildResponse(responseBuilder, listenerResponseBuilder, supportStreaming);
    }

    protected HttpResponse doBuildResponse(HttpResponseBuilder responseBuilder, HttpListenerResponseBuilder listenerResponseBuilder, boolean supportsStreaming) throws Exception {
        return this.responseFactory.create(responseBuilder, listenerResponseBuilder, supportsStreaming);
    }

    protected HttpResponse buildErrorResponse() {
        HttpResponseBuilder errorResponseBuilder = HttpResponse.builder();
        HttpResponse errorResponse = errorResponseBuilder.setStatusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).setReasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
        return errorResponse;
    }

    private ResponseStatusCallback getResponseFailureCallback(final HttpResponseReadyCallback responseReadyCallback) {
        return new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
                responseReadyCallback.responseReady(HttpListener.this.buildErrorResponse(), (ResponseStatusCallback)this);
            }

            public void responseSendSuccessfully() {
            }
        };
    }

    private boolean supportsTransferEncoding(String httpVersion) {
        return !HttpProtocol.HTTP_0_9.asString().equals(httpVersion) && !HttpProtocol.HTTP_1_0.asString().equals(httpVersion);
    }

    private String[] extractAllowedMethods() throws InitialisationException {
        String[] values = this.allowedMethods.split(",");
        String[] normalizedValues = new String[values.length];
        int normalizedValueIndex = 0;
        for (String value : values) {
            normalizedValues[normalizedValueIndex] = value.trim().toUpperCase();
            ++normalizedValueIndex;
        }
        return normalizedValues;
    }

    private void validatePath() {
        String[] pathParts = this.path.split("/");
        ArrayList<String> uriParamNames = new ArrayList<String>();
        for (String pathPart : pathParts) {
            if (pathPart.startsWith("{") && pathPart.endsWith("}")) {
                String uriParamName = pathPart.substring(1, pathPart.length() - 1);
                if (uriParamNames.contains(uriParamName)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Http Listener with path %s contains duplicated uri param names", this.path)));
                }
                uriParamNames.add(uriParamName);
                continue;
            }
            if (!pathPart.contains("*") || pathPart.length() <= 1) continue;
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Http Listener with path %s contains an invalid use of a wildcard. Wildcards can only be used at the end of the path (i.e.: /path/*) or between / characters (.i.e.: /path/*/anotherPath))", this.path)));
        }
    }

    public Boolean getParseRequest() {
        return this.parseRequest;
    }
}

