/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.request.DefaultHttpRequester;
import org.mule.runtime.module.http.internal.util.HttpToMuleMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseToMuleEvent {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseToMuleEvent.class);
    private static final String MULTI_PART_PREFIX = "multipart/";
    private DefaultHttpRequester requester;
    private MuleContext muleContext;
    private AttributeEvaluator parseResponse;

    public HttpResponseToMuleEvent(DefaultHttpRequester requester, MuleContext muleContext, AttributeEvaluator parseResponse) {
        this.requester = requester;
        this.muleContext = muleContext;
        this.parseResponse = parseResponse;
    }

    public Event convert(Event muleEvent, HttpResponse response, String uri) throws MessagingException {
        Event.Builder eventBuilder = Event.builder((Event)muleEvent);
        String responseContentType = response.getHeaderValueIgnoreCase("Content-Type");
        DataType dataType = muleEvent.getMessage().getPayload().getDataType();
        if (StringUtils.isEmpty((String)responseContentType) && !MediaType.ANY.matches(dataType.getMediaType())) {
            responseContentType = dataType.getMediaType().toRfcString();
        }
        InputStream responseInputStream = ((InputStreamHttpEntity)response.getEntity()).getInputStream();
        Charset encoding = (Charset)HttpToMuleMessage.getMediaType(responseContentType, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext)).getCharset().get();
        Map<String, Serializable> inboundProperties = this.getInboundProperties(response);
        InputStream payload = responseInputStream;
        if (responseContentType != null && this.parseResponse.resolveBooleanValue(muleEvent).booleanValue()) {
            if (responseContentType.startsWith(MULTI_PART_PREFIX)) {
                try {
                    payload = HttpPartDataSource.multiPartPayloadForAttachments(responseContentType, responseInputStream);
                }
                catch (IOException e) {
                    throw new MessagingException(muleEvent, (Throwable)e);
                }
            } else if (responseContentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())) {
                payload = HttpParser.decodeString(IOUtils.toString((InputStream)responseInputStream), encoding);
            }
        }
        InternalMessage.Builder builder = InternalMessage.builder().payload(muleEvent.getMessage().getPayload().getValue()).inboundProperties(inboundProperties);
        if (StringUtils.isEmpty((String)responseContentType)) {
            builder.mediaType(muleEvent.getMessage().getPayload().getDataType().getMediaType());
        } else {
            builder.mediaType(MediaType.parse((String)responseContentType));
        }
        eventBuilder.message(builder.build());
        this.setResponsePayload(payload, eventBuilder.build(), eventBuilder);
        if (this.requester.getConfig().isEnableCookies()) {
            this.processCookies(response, uri);
        }
        return eventBuilder.build();
    }

    private Map<String, Serializable> getInboundProperties(HttpResponse response) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        for (String headerName : response.getHeaderNames()) {
            if ("Content-Type".equalsIgnoreCase(headerName)) continue;
            properties.put(headerName, this.getHeaderValueToProperty(response, headerName));
        }
        properties.put("http.status", Integer.valueOf(response.getStatusCode()));
        properties.put("http.reason", (Serializable)((Object)response.getReasonPhrase()));
        return properties;
    }

    private Serializable getHeaderValueToProperty(HttpResponse response, String headerName) {
        Collection<String> headerValues = response.getHeaderValues(headerName);
        if (headerValues.size() > 1) {
            return new ArrayList<String>(headerValues);
        }
        return response.getHeaderValue(headerName);
    }

    private void setResponsePayload(Object payload, Event muleEvent, Event.Builder eventBuilder) {
        if (StringUtils.isEmpty((String)this.requester.getTarget()) || "#[payload]".equals(this.requester.getTarget())) {
            eventBuilder.message(InternalMessage.builder((InternalMessage)muleEvent.getMessage()).payload(payload).mediaType(muleEvent.getMessage().getPayload().getDataType().getMediaType()).build());
        } else {
            this.muleContext.getExpressionManager().enrich(this.requester.getTarget(), muleEvent, eventBuilder, null, payload);
        }
    }

    private void processCookies(HttpResponse response, String uri) {
        Collection<String> setCookieHeader = response.getHeaderValuesIgnoreCase("Set-Cookie");
        Collection<String> setCookie2Header = response.getHeaderValuesIgnoreCase("Set-Cookie2");
        HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
        if (setCookieHeader != null) {
            cookieHeaders.put("Set-Cookie", new ArrayList<String>(setCookieHeader));
        }
        if (setCookie2Header != null) {
            cookieHeaders.put("Set-Cookie2", new ArrayList<String>(setCookie2Header));
        }
        try {
            this.requester.getConfig().getCookieManager().put(URI.create(uri), cookieHeaders);
        }
        catch (IOException e) {
            logger.warn("Error storing cookies for URI " + uri, (Throwable)e);
        }
    }
}

