/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener.matcher;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.listener.matcher.RequestMatcher;

public class MethodRequestMatcher
implements RequestMatcher {
    private final List<String> methods;

    public MethodRequestMatcher(String ... methods) {
        Preconditions.checkArgument((methods != null ? 1 : 0) != 0, (String)"methods attribute should not be null");
        this.methods = (List)CollectionUtils.collect(Arrays.asList(methods), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((String)input).toLowerCase();
            }
        });
    }

    public boolean intersectsWith(MethodRequestMatcher methodRequestMatcher) {
        Preconditions.checkArgument((methodRequestMatcher != null ? 1 : 0) != 0, (String)"methodRequestMatcher cannot be null");
        for (String method : this.methods) {
            if (!methodRequestMatcher.methods.contains(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(HttpRequest httpRequest) {
        return this.methods.contains(httpRequest.getMethod().toLowerCase());
    }

    public String toString() {
        return "MethodRequestMatcher{methods=" + this.getMethodsList() + '}';
    }

    public String getMethodsList() {
        return this.methods.isEmpty() ? "*" : Arrays.toString(this.methods.toArray());
    }
}

