/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.ObjectNameHelper;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.api.listener.HttpListenerConfig;
import org.mule.runtime.module.http.internal.listener.DefaultHttpListenerConfig;

public class HttpListenerConfigBuilder {
    private final DefaultHttpListenerConfig config = new DefaultHttpListenerConfig();
    private final MuleContext muleContext;

    public HttpListenerConfigBuilder(String name, MuleContext muleContext) {
        this.config.setMuleContext(muleContext);
        this.config.setName(name);
        this.muleContext = muleContext;
    }

    public HttpListenerConfigBuilder(MuleContext muleContext) {
        this(HttpListenerConfigBuilder.getNextAutoGeneratedConfigName(muleContext), muleContext);
    }

    private static String getNextAutoGeneratedConfigName(MuleContext muleContext) {
        return new ObjectNameHelper(muleContext).getUniqueName("auto-generated-listener-config");
    }

    public HttpListenerConfigBuilder setPort(int port) {
        this.config.setPort(port);
        return this;
    }

    public HttpListenerConfigBuilder setHost(String host) {
        this.config.setHost(host);
        return this;
    }

    public HttpListenerConfigBuilder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
        this.config.setTlsContext(tlsContextFactory);
        this.config.setProtocol(HttpConstants.Protocols.HTTPS);
        return this;
    }

    public HttpListenerConfig build() throws MuleException {
        try {
            this.muleContext.getRegistry().registerObject(this.config.getName(), (Object)this.config);
            this.config.initialise();
            this.config.start();
            return this.config;
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }
}

