/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.api.requester;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.ObjectNameHelper;
import org.mule.runtime.module.http.api.HttpAuthentication;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.api.requester.HttpRequesterConfig;
import org.mule.runtime.module.http.api.requester.HttpSendBodyMode;
import org.mule.runtime.module.http.api.requester.HttpStreamingType;
import org.mule.runtime.module.http.api.requester.proxy.ProxyConfig;
import org.mule.runtime.module.http.internal.request.DefaultHttpRequesterConfig;

public class HttpRequesterConfigBuilder {
    private final MuleContext muleContext;
    private DefaultHttpRequesterConfig defaultHttpRequesterConfig = new DefaultHttpRequesterConfig();

    public HttpRequesterConfigBuilder(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.defaultHttpRequesterConfig.setMuleContext(muleContext);
    }

    public HttpRequesterConfigBuilder setAuthentication(HttpAuthentication authentication) {
        this.defaultHttpRequesterConfig.setAuthentication(authentication);
        return this;
    }

    public HttpRequesterConfigBuilder setTlsContext(TlsContextFactory tlsContext) {
        this.defaultHttpRequesterConfig.setTlsContext(tlsContext);
        return this;
    }

    public HttpRequesterConfigBuilder setProxyConfig(ProxyConfig proxyConfig) {
        this.defaultHttpRequesterConfig.setProxyConfig(proxyConfig);
        return this;
    }

    public HttpRequesterConfigBuilder setResponseTimeout(int responseTimeout) {
        this.setResponseTimeoutExpression(String.valueOf(responseTimeout));
        return this;
    }

    public HttpRequesterConfigBuilder setMaxConnections(int maxConnections) {
        this.defaultHttpRequesterConfig.setMaxConnections(maxConnections);
        return this;
    }

    public HttpRequesterConfigBuilder setUsePersistentConnections(boolean usePersistentConnections) {
        this.defaultHttpRequesterConfig.setUsePersistentConnections(usePersistentConnections);
        return this;
    }

    public HttpRequesterConfigBuilder setConnectionIdleTimeout(int connectionIdleTimeout) {
        this.defaultHttpRequesterConfig.setConnectionIdleTimeout(connectionIdleTimeout);
        return this;
    }

    public HttpRequesterConfigBuilder setProtocol(HttpConstants.Protocols protocol) {
        this.defaultHttpRequesterConfig.setProtocol(protocol);
        return this;
    }

    public HttpRequesterConfigBuilder setHostExpression(String host) {
        this.defaultHttpRequesterConfig.setHost(host);
        return this;
    }

    public HttpRequesterConfigBuilder setPortExpression(String port) {
        this.defaultHttpRequesterConfig.setPort(port);
        return this;
    }

    public HttpRequesterConfigBuilder setPort(int port) {
        this.defaultHttpRequesterConfig.setPort(String.valueOf(port));
        return this;
    }

    public HttpRequesterConfigBuilder setResponseTimeoutExpression(String responseTimeoutExpression) {
        this.defaultHttpRequesterConfig.setResponseTimeout(responseTimeoutExpression);
        return this;
    }

    public HttpRequesterConfigBuilder setParseResponse(boolean parseResponse) {
        this.setParseResponseExpression(Boolean.toString(parseResponse));
        return this;
    }

    public HttpRequesterConfigBuilder setParseResponseExpression(String parseResponse) {
        this.defaultHttpRequesterConfig.setParseResponse(parseResponse);
        return this;
    }

    public HttpRequesterConfigBuilder setSendBodyMode(HttpSendBodyMode sendBodyMode) {
        return this.setSendBodyModeExpression(sendBodyMode.name());
    }

    public HttpRequesterConfigBuilder setSendBodyModeExpression(String sendBodyMode) {
        this.defaultHttpRequesterConfig.setSendBodyMode(sendBodyMode);
        return this;
    }

    public HttpRequesterConfigBuilder setRequestStreamingMode(HttpStreamingType requestStreamingMode) {
        return this.setRequestStreamingModeExpression(requestStreamingMode.name());
    }

    public HttpRequesterConfigBuilder setRequestStreamingModeExpression(String requestStreamingMode) {
        this.defaultHttpRequesterConfig.setRequestStreamingMode(requestStreamingMode);
        return this;
    }

    public HttpRequesterConfig build() throws MuleException {
        try {
            if (this.defaultHttpRequesterConfig.getName() == null) {
                this.defaultHttpRequesterConfig.setName(new ObjectNameHelper(this.muleContext).getUniqueName("auto-generated-http-request"));
            }
            this.defaultHttpRequesterConfig.initialise();
            this.defaultHttpRequesterConfig.start();
        }
        catch (InitialisationException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        return this.defaultHttpRequesterConfig;
    }
}

