/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.builder.HttpResponseAttributesBuilder;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.module.http.api.HttpHeaders;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.runtime.module.http.internal.domain.response.HttpResponse;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.util.HttpToMuleMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseToMuleMessage {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseToMuleMessage.class);
    private static final String MULTI_PART_PREFIX = "multipart/";
    private final Boolean parseResponse;
    private final HttpRequesterConfig config;
    private final MuleContext muleContext;

    public HttpResponseToMuleMessage(HttpRequesterConfig config, Boolean parseResponse, MuleContext muleContext) {
        this.config = config;
        this.parseResponse = parseResponse;
        this.muleContext = muleContext;
    }

    public Message convert(Event muleEvent, HttpResponse response, String uri) throws MessagingException {
        String responseContentType = response.getHeaderValueIgnoreCase("Content-Type");
        DataType dataType = muleEvent.getMessage().getPayload().getDataType();
        if (StringUtils.isEmpty((String)responseContentType) && !MediaType.ANY.matches(dataType.getMediaType())) {
            responseContentType = dataType.getMediaType().toRfcString();
        }
        InputStream responseInputStream = ((InputStreamHttpEntity)response.getEntity()).getInputStream();
        Charset encoding = (Charset)HttpToMuleMessage.getMediaType(responseContentType, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext)).getCharset().get();
        InputStream payload = responseInputStream;
        if (responseContentType != null && this.parseResponse.booleanValue()) {
            if (responseContentType.startsWith(MULTI_PART_PREFIX)) {
                try {
                    payload = HttpPartDataSource.multiPartPayloadForAttachments(responseContentType, responseInputStream);
                }
                catch (IOException e) {
                    throw new MessagingException(muleEvent, (Throwable)e);
                }
            } else if (responseContentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())) {
                payload = HttpParser.decodeString(IOUtils.toString((InputStream)responseInputStream), encoding);
            }
        }
        if (this.config.isEnableCookies()) {
            this.processCookies(response, uri);
        }
        HttpResponseAttributes responseAttributes = this.createAttributes(response);
        dataType = DataType.builder((DataType)dataType).charset(encoding).build();
        Message.Builder builder = Message.builder((Message)muleEvent.getMessage()).payload((Object)payload);
        if (StringUtils.isEmpty((String)responseContentType)) {
            builder.mediaType(dataType.getMediaType());
        } else {
            builder.mediaType(MediaType.parse((String)responseContentType));
        }
        return builder.attributes((Attributes)responseAttributes).build();
    }

    private HttpResponseAttributes createAttributes(HttpResponse response) {
        return new HttpResponseAttributesBuilder().setResponse(response).build();
    }

    private void processCookies(HttpResponse response, String uri) {
        Collection<String> setCookieHeader = response.getHeaderValuesIgnoreCase("Set-Cookie");
        Collection<String> setCookie2Header = response.getHeaderValuesIgnoreCase("Set-Cookie2");
        HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
        if (setCookieHeader != null) {
            cookieHeaders.put("Set-Cookie", new ArrayList<String>(setCookieHeader));
        }
        if (setCookie2Header != null) {
            cookieHeaders.put("Set-Cookie2", new ArrayList<String>(setCookie2Header));
        }
        try {
            this.config.getCookieManager().put(URI.create(uri), cookieHeaders);
        }
        catch (IOException e) {
            logger.warn("Error storing cookies for URI " + uri, (Throwable)e);
        }
    }
}

