/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.function.Function;
import javax.inject.Inject;
import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.client.HttpClient;
import org.mule.extension.http.api.request.proxy.ProxyConfig;
import org.mule.extension.http.internal.request.RequestConnectionParams;
import org.mule.extension.http.internal.request.client.DefaultUriParameters;
import org.mule.extension.http.internal.request.client.HttpClientConfiguration;
import org.mule.extension.http.internal.request.client.HttpClientFactory;
import org.mule.extension.http.internal.request.grizzly.GrizzlyHttpClient;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.util.concurrent.ThreadNameHelper;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ConfigName;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.tls.api.DefaultTlsContextFactoryBuilder;

@Alias(value="request")
public class HttpRequesterProvider
implements CachedConnectionProvider<HttpClient>,
Initialisable {
    private static final int UNLIMITED_CONNECTIONS = -1;
    private static final String OBJECT_HTTP_CLIENT_FACTORY = "_httpClientFactory";
    private static final String THREAD_NAME_PREFIX_PATTERN = "%shttp.requester.%s";
    @Inject
    private MuleContext muleContext;
    @ConfigName
    private String configName;
    @ParameterGroup(value="Connection")
    private RequestConnectionParams connectionParams;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="Security")
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    private ProxyConfig proxyConfig;
    @Parameter
    @Optional
    @Placement(tab="Authentication")
    private HttpAuthentication authentication;
    @Inject
    @DefaultTlsContextFactoryBuilder
    private TlsContextFactoryBuilder defaultTlsContextFactoryBuilder;
    private HttpClientFactory httpClientFactory;

    public ConnectionValidationResult validate(HttpClient httpClient) {
        return ConnectionValidationResult.success();
    }

    public void initialise() throws InitialisationException {
        HttpConstants.Protocols protocol = this.connectionParams.getProtocol();
        if (this.connectionParams.getPort() == null) {
            this.connectionParams.setPort(muleEvent -> protocol.getDefaultPort());
        }
        if (protocol.equals((Object)HttpConstants.Protocols.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP, when using tls:context you must set attribute protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (protocol.equals((Object)HttpConstants.Protocols.HTTPS) && this.tlsContext == null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.defaultTlsContextFactoryBuilder);
            this.tlsContext = this.defaultTlsContextFactoryBuilder.buildDefault();
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        if (this.authentication != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.authentication);
        }
        this.verifyConnectionsParameters();
        this.httpClientFactory = (HttpClientFactory)this.muleContext.getRegistry().get(OBJECT_HTTP_CLIENT_FACTORY);
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (this.connectionParams.getMaxConnections() < -1 || this.connectionParams.getMaxConnections() == 0) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"The maxConnections parameter only allows positive values or -1 for unlimited concurrent connections."), (Initialisable)this);
        }
        if (!this.connectionParams.getUsePersistentConnections().booleanValue()) {
            this.connectionParams.setConnectionIdleTimeout(0);
        }
    }

    public HttpClient connect() throws ConnectionException {
        String threadNamePrefix = String.format(THREAD_NAME_PREFIX_PATTERN, ThreadNameHelper.getPrefix((MuleContext)this.muleContext), this.configName);
        HttpClientConfiguration configuration = new HttpClientConfiguration.Builder().setUriParameters(new DefaultUriParameters(this.connectionParams.getProtocol(), this.connectionParams.getHost(), this.connectionParams.getPort())).setAuthentication(this.authentication).setTlsContextFactory(this.tlsContext).setProxyConfig(this.proxyConfig).setClientSocketProperties(this.connectionParams.getClientSocketProperties()).setMaxConnections(this.connectionParams.getMaxConnections()).setUsePersistentConnections(this.connectionParams.getUsePersistentConnections()).setConnectionIdleTimeout(this.connectionParams.getConnectionIdleTimeout()).setThreadNamePrefix(threadNamePrefix).setOwnerName(this.configName).build();
        HttpClient httpClient = this.httpClientFactory == null ? new GrizzlyHttpClient(configuration) : this.httpClientFactory.create(configuration);
        return httpClient;
    }

    public void disconnect(HttpClient httpClient) {
    }

    public Function<Event, Integer> getPort() {
        return this.connectionParams.getPort();
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public HttpAuthentication getAuthentication() {
        return this.authentication;
    }
}

