/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.function.Function;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.HttpClient;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.SuccessStatusCodeValidator;
import org.mule.extension.http.internal.HttpRequestMetadataResolver;
import org.mule.extension.http.internal.request.ConfigurationOverrides;
import org.mule.extension.http.internal.request.HttpRequester;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.OutputSettings;
import org.mule.extension.http.internal.request.ResponseValidationSettings;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.HttpParser;

public class HttpRequestOperations {
    private static final int WAIT_FOR_EVER = Integer.MAX_VALUE;
    @Inject
    private MuleContext muleContext;

    @Summary(value="Executes a HTTP Request")
    @OutputResolver(output=HttpRequestMetadataResolver.class)
    public Result<Object, HttpResponseAttributes> request(String path, @Optional(defaultValue="GET") String method, @ParameterGroup(value="Configuration Overrides") ConfigurationOverrides overrides, @ParameterGroup(value="Response Validation Settings") ResponseValidationSettings responseValidationSettings, @Optional @NullSafe @Expression(value=ExpressionSupport.NOT_SUPPORTED) HttpRequesterRequestBuilder requestBuilder, @ParameterGroup(value="Other Settings") OutputSettings outputSettings, @Connection HttpClient client, @UseConfig HttpRequesterConfig config, Event muleEvent) throws MuleException {
        HttpRequesterRequestBuilder resolvedBuilder = requestBuilder != null ? requestBuilder : new HttpRequesterRequestBuilder();
        UriParameters uriParameters = client.getDefaultUriParameters();
        String resolvedHost = this.resolveIfNecessary(overrides.getHost(), uriParameters.getHost(), muleEvent);
        Integer resolvedPort = this.resolveIfNecessary(overrides.getPort(), uriParameters.getPort(), muleEvent);
        String resolvedBasePath = config.getBasePath().apply(muleEvent);
        String resolvedPath = resolvedBuilder.replaceUriParams(this.buildPath(resolvedBasePath, path));
        String resolvedUri = this.resolveUri(uriParameters.getScheme(), resolvedHost, resolvedPort, resolvedPath);
        Boolean resolvedFollowRedirects = this.resolveIfNecessary(overrides.getFollowRedirects(), config.getFollowRedirects(), muleEvent);
        HttpStreamingType resolvedStreamingMode = this.resolveIfNecessary(overrides.getRequestStreamingMode(), config.getRequestStreamingMode(), muleEvent);
        HttpSendBodyMode resolvedSendBody = this.resolveIfNecessary(overrides.getSendBodyMode(), config.getSendBodyMode(), muleEvent);
        Boolean resolvedParseResponse = this.resolveIfNecessary(overrides.getParseResponse(), config.getParseResponse(), muleEvent);
        Integer resolvedTimeout = this.resolveResponseTimeout(muleEvent, config, overrides.getResponseTimeout());
        ResponseValidator responseValidator = responseValidationSettings.getResponseValidator();
        responseValidator = responseValidator != null ? responseValidator : new SuccessStatusCodeValidator("0..399");
        HttpRequester requester = new HttpRequester.Builder().setUri(resolvedUri).setMethod(method).setFollowRedirects(resolvedFollowRedirects).setRequestStreamingMode(resolvedStreamingMode).setSendBodyMode(resolvedSendBody).setAuthentication(client.getDefaultAuthentication()).setParseResponse(resolvedParseResponse).setResponseTimeout(resolvedTimeout).setResponseValidator(responseValidator).setConfig(config).setTransformationService(this.muleContext.getTransformationService()).build();
        Flow flowConstruct = new Flow("httpRequestOperation", this.muleContext);
        return Result.builder((Message)requester.doRequest(muleEvent, client, resolvedBuilder, true, this.muleContext, (FlowConstruct)flowConstruct)).build();
    }

    private <T> T resolveIfNecessary(T value, Function<Event, T> function, Event event) {
        return value != null ? value : function.apply(event);
    }

    private String resolveUri(HttpConstants.Protocols scheme, String host, Integer port, String path) {
        String resolvedPath = HttpParser.encodeSpaces(path);
        return String.format("%s://%s:%s%s", scheme.getScheme(), host, port, resolvedPath);
    }

    private int resolveResponseTimeout(Event muleEvent, HttpRequesterConfig config, Integer responseTimeout) {
        if (responseTimeout == null && config.getResponseTimeout() != null) {
            responseTimeout = config.getResponseTimeout().apply(muleEvent);
        }
        if (this.muleContext.getConfiguration().isDisableTimeouts()) {
            return Integer.MAX_VALUE;
        }
        return responseTimeout != null ? responseTimeout.intValue() : this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected String buildPath(String basePath, String path) {
        String resolvedBasePath = basePath;
        String resolvedRequestPath = path;
        if (!resolvedBasePath.startsWith("/")) {
            resolvedBasePath = "/" + resolvedBasePath;
        }
        if (resolvedBasePath.endsWith("/") && resolvedRequestPath.startsWith("/")) {
            resolvedBasePath = resolvedBasePath.substring(0, resolvedBasePath.length() - 1);
        }
        if (!(resolvedBasePath.endsWith("/") || resolvedRequestPath.startsWith("/") || resolvedRequestPath.isEmpty())) {
            resolvedBasePath = resolvedBasePath + "/";
        }
        return resolvedBasePath + resolvedRequestPath;
    }
}

