/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.Map;
import org.mule.extension.http.internal.request.DefaultHttpRequest;
import org.mule.runtime.core.model.ParameterMap;
import org.mule.runtime.module.http.internal.CaseInsensitiveParameterMap;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.HttpEntity;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;

public class HttpRequestBuilder {
    private String path;
    private String uri;
    private String method;
    private CaseInsensitiveParameterMap headers;
    private ParameterMap queryParams;
    private HttpEntity entity;

    public HttpRequestBuilder setUri(String uri) {
        this.path = HttpParser.extractPath(uri.toString());
        this.uri = uri;
        return this;
    }

    public HttpRequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder setHeaders(ParameterMap headers) {
        this.headers = new CaseInsensitiveParameterMap(headers);
        return this;
    }

    public HttpRequestBuilder addHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
        return this;
    }

    public HttpRequestBuilder removeHeader(String headerName) {
        this.headers.remove(headerName);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpRequestBuilder setQueryParams(ParameterMap queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public HttpRequestBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public HttpRequest build() {
        return new DefaultHttpRequest(this.uri, this.path, this.method, this.headers == null ? null : this.headers.toImmutableParameterMap(), this.queryParams == null ? this.queryParams : this.queryParams.toImmutableParameterMap(), this.entity);
    }
}

