/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener.server;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.mule.extension.http.internal.listener.grizzly.GrizzlyServerManager;
import org.mule.extension.http.internal.listener.server.HttpServerConfiguration;
import org.mule.extension.http.internal.listener.server.HttpServerFactory;
import org.mule.extension.socket.api.socket.tcp.TcpServerSocketProperties;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.NetworkUtils;
import org.mule.runtime.core.util.concurrent.ThreadNameHelper;
import org.mule.runtime.module.http.internal.listener.HttpListenerRegistry;
import org.mule.runtime.module.http.internal.listener.HttpServerManager;
import org.mule.runtime.module.http.internal.listener.Server;
import org.mule.runtime.module.http.internal.listener.ServerAddress;

public class HttpListenerConnectionManager
implements HttpServerFactory,
Initialisable,
Disposable,
MuleContextAware {
    public static final String HTTP_LISTENER_CONNECTION_MANAGER = "_httpExtListenerConnectionManager";
    public static final String SERVER_ALREADY_EXISTS_FORMAT = "A server in port(%s) already exists for ip(%s) or one overlapping it (0.0.0.0).";
    private static final String LISTENER_THREAD_NAME_PREFIX = "http.listener";
    private HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
    private HttpServerManager httpServerManager;
    private MuleContext muleContext;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public void initialise() throws InitialisationException {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        Collection tcpServerSocketPropertiesBeans = this.muleContext.getRegistry().lookupObjects(TcpServerSocketProperties.class);
        TcpServerSocketProperties tcpServerSocketProperties = new TcpServerSocketProperties();
        if (tcpServerSocketPropertiesBeans.size() == 1) {
            tcpServerSocketProperties = (TcpServerSocketProperties)Iterables.getOnlyElement((Iterable)tcpServerSocketPropertiesBeans);
        } else if (tcpServerSocketPropertiesBeans.size() > 1) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"Only one global TCP server socket properties bean should be defined in the config"), (Initialisable)this);
        }
        String threadNamePrefix = ThreadNameHelper.getPrefix((MuleContext)this.muleContext) + LISTENER_THREAD_NAME_PREFIX;
        try {
            this.httpServerManager = new GrizzlyServerManager(threadNamePrefix, this.httpListenerRegistry, tcpServerSocketProperties);
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void dispose() {
        this.httpServerManager.dispose();
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public Server create(HttpServerConfiguration serverConfiguration) throws ConnectionException {
        ServerAddress serverAddress;
        String host = serverConfiguration.getHost();
        try {
            serverAddress = this.createServerAddress(host, serverConfiguration.getPort());
        }
        catch (UnknownHostException e) {
            throw new ConnectionException(String.format("Cannot resolve host %s", host), (Throwable)e);
        }
        TlsContextFactory tlsContextFactory = serverConfiguration.getTlsContextFactory();
        if (tlsContextFactory == null) {
            return this.createServer(serverAddress, serverConfiguration.getWorkManagerSupplier(), serverConfiguration.isUsePersistentConnections(), serverConfiguration.getConnectionIdleTimeout());
        }
        return this.createSslServer(serverAddress, serverConfiguration.getWorkManagerSupplier(), tlsContextFactory, serverConfiguration.isUsePersistentConnections(), serverConfiguration.getConnectionIdleTimeout());
    }

    public Server createServer(ServerAddress serverAddress, Supplier<Executor> workManagerSource, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createServerFor(serverAddress, workManagerSource, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    public boolean containsServerFor(ServerAddress serverAddress) {
        return this.httpServerManager.containsServerFor(serverAddress);
    }

    public Server createSslServer(ServerAddress serverAddress, Supplier<Executor> workManagerSource, TlsContextFactory tlsContext, boolean usePersistentConnections, int connectionIdleTimeout) {
        if (!this.containsServerFor(serverAddress)) {
            try {
                return this.httpServerManager.createSslServerFor(tlsContext, workManagerSource, serverAddress, usePersistentConnections, connectionIdleTimeout);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format(SERVER_ALREADY_EXISTS_FORMAT, serverAddress.getPort(), serverAddress.getIp())));
    }

    private ServerAddress createServerAddress(String host, int port) throws UnknownHostException {
        return new ServerAddress(NetworkUtils.getLocalHostIp((String)host), port);
    }
}

