/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.security.cert.Certificate;
import java.util.Collection;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.runtime.core.model.ParameterMap;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.runtime.module.http.internal.domain.request.ClientConnection;
import org.mule.runtime.module.http.internal.domain.request.HttpRequest;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestContext;
import org.mule.runtime.module.http.internal.listener.ListenerPath;

public class HttpRequestAttributesBuilder {
    private HttpRequestContext requestContext;
    private ListenerPath listenerPath;

    public HttpRequestAttributesBuilder setRequestContext(HttpRequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public HttpRequestAttributesBuilder setListenerPath(ListenerPath listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public HttpRequestAttributes build() {
        String listenerPath = this.listenerPath.getResolvedPath();
        HttpRequest request = this.requestContext.getRequest();
        String version = request.getProtocol().asString();
        String scheme = this.requestContext.getScheme();
        String method = request.getMethod();
        String uri = request.getUri();
        String path = HttpParser.extractPath(uri);
        String queryString = HttpParser.extractQueryParams(uri);
        ParameterMap queryParams = HttpParser.decodeQueryString(queryString);
        ParameterMap uriParams = HttpParser.decodeUriParams(listenerPath, path);
        ClientConnection clientConnection = this.requestContext.getClientConnection();
        String remoteHostAddress = clientConnection.getRemoteHostAddress().toString();
        Certificate clientCertificate = clientConnection.getClientCertificate();
        String relativePath = this.listenerPath.getRelativePath(path);
        Collection<String> headerNames = request.getHeaderNames();
        ParameterMap headers = new ParameterMap();
        for (String headerName : headerNames) {
            headers.put(headerName, request.getHeaderValues(headerName));
        }
        return new HttpRequestAttributes(headers, listenerPath, relativePath, version, scheme, method, path, uri, queryString, queryParams, uriParams, remoteHostAddress, clientCertificate);
    }
}

