/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.extension.http.internal.listener.server.HttpListenerConnectionManager;
import org.mule.extension.http.internal.listener.server.HttpServerConfiguration;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionExceptionCode;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.scheduler.Scheduler;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ConfigName;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.internal.listener.Server;
import org.mule.runtime.module.http.internal.listener.ServerAddress;

@Alias(value="listener")
public class HttpListenerProvider
implements CachedConnectionProvider<Server>,
Initialisable,
Startable,
Stoppable {
    @ConfigName
    private String configName;
    @ParameterGroup(value="Connection")
    private ConnectionParams connectionParams;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="Security")
    private TlsContextFactory tlsContext;
    @Inject
    private HttpListenerConnectionManager connectionManager;
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler workManager;
    private Server server;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.connectionManager);
        if (this.connectionParams.port == null) {
            this.connectionParams.port = this.connectionParams.protocol.getDefaultPort();
        }
        if (this.connectionParams.protocol.equals((Object)HttpConstants.Protocols.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP. If you defined a tls:context element in your listener-config then you must set protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (this.connectionParams.protocol.equals((Object)HttpConstants.Protocols.HTTPS) && this.tlsContext == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Configured protocol is HTTPS but there's no TlsContext configured"), (Initialisable)this);
        }
        if (this.tlsContext != null && !this.tlsContext.isKeyStoreConfigured()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        this.verifyConnectionsParameters();
        HttpServerConfiguration serverConfiguration = new HttpServerConfiguration.Builder().setHost(this.connectionParams.getHost()).setPort(this.connectionParams.getPort()).setTlsContextFactory(this.tlsContext).setUsePersistentConnections(this.connectionParams.getUsePersistentConnections()).setConnectionIdleTimeout(this.connectionParams.getConnectionIdleTimeout()).setWorkManagerSource(() -> this.workManager).build();
        try {
            this.server = this.connectionManager.create(serverConfiguration);
        }
        catch (ConnectionException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Could not create HTTP server"), (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        this.workManager = this.schedulerService.cpuLightScheduler();
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)new ConnectionException("Could not start HTTP server", (Throwable)e));
        }
    }

    public void stop() throws MuleException {
        try {
            this.server.stop();
        }
        finally {
            try {
                this.workManager.stop((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            finally {
                this.workManager = null;
            }
        }
    }

    public Server connect() throws ConnectionException {
        return this.server;
    }

    public void disconnect(Server server) {
    }

    public ConnectionValidationResult validate(Server server) {
        if (server.isStopped() || server.isStopping()) {
            ServerAddress serverAddress = server.getServerAddress();
            return ConnectionValidationResult.failure((String)String.format("Server on host %s and port %s is stopped.", serverAddress.getIp(), serverAddress.getPort()), (ConnectionExceptionCode)ConnectionExceptionCode.UNKNOWN, (Exception)((Object)new ConnectionException("Server stopped.")));
        }
        return ConnectionValidationResult.success();
    }

    public ConnectionParams getConnectionParams() {
        return this.connectionParams;
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (!this.connectionParams.getUsePersistentConnections().booleanValue()) {
            this.connectionParams.connectionIdleTimeout = 0;
        }
    }

    private Supplier<Executor> createWorkManagerSource() {
        return () -> this.workManager;
    }

    public static final class ConnectionParams {
        @Parameter
        @Optional(defaultValue="HTTP")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(order=1)
        private HttpConstants.Protocols protocol;
        @Parameter
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(order=2)
        private String host;
        @Parameter
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(order=3)
        private Integer port;
        @Parameter
        @Optional(defaultValue="true")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(tab="Advanced", order=1)
        private Boolean usePersistentConnections;
        @Parameter
        @Optional(defaultValue="30000")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(tab="Advanced", order=2)
        private Integer connectionIdleTimeout;

        public HttpConstants.Protocols getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public Boolean getUsePersistentConnections() {
            return this.usePersistentConnections;
        }

        public Integer getConnectionIdleTimeout() {
            return this.connectionIdleTimeout;
        }
    }
}

