/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.policy;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.listener.builder.HttpListenerErrorResponseBuilder;
import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.api.listener.builder.HttpListenerSuccessResponseBuilder;
import org.mule.extension.http.api.policy.HttpPolicyResponseAttributes;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.model.ParameterMap;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class HttpListenerPolicyParametersTransformer
implements SourcePolicyParametersTransformer {
    public boolean supports(ComponentIdentifier componentIdentifier) {
        return componentIdentifier.equals((Object)ComponentIdentifier.parseComponentIdentifier((String)"http:listener"));
    }

    public Message fromSuccessResponseParametersToMessage(Map<String, Object> parameters) {
        HttpListenerResponseBuilder responseBuilder = (HttpListenerResponseBuilder)parameters.get("responseBuilder");
        return this.responseParametersToMessage(responseBuilder);
    }

    private Message responseParametersToMessage(HttpListenerResponseBuilder responseBuilder) {
        ParameterMap headers = new ParameterMap(responseBuilder.getHeaders());
        Message.PayloadBuilder builder = Message.builder();
        Message.Builder messageBuilder = responseBuilder.getBody() == null ? builder.nullPayload() : builder.payload(responseBuilder.getBody());
        return messageBuilder.attributes((Attributes)new HttpResponseAttributes(responseBuilder.getStatusCode(), responseBuilder.getReasonPhrase(), headers)).build();
    }

    public Message fromFailureResponseParametersToMessage(Map<String, Object> parameters) {
        HttpListenerResponseBuilder responseBuilder = (HttpListenerResponseBuilder)parameters.get("errorResponseBuilder");
        return this.responseParametersToMessage(responseBuilder);
    }

    public Map<String, Object> fromMessageToSuccessResponseParameters(Message message) {
        return this.messageToResponseParameters(new HttpListenerSuccessResponseBuilder(), "responseBuilder", message);
    }

    public Map<String, Object> fromMessageToErrorResponseParameters(Message message) {
        return this.messageToResponseParameters(new HttpListenerErrorResponseBuilder(), "errorResponseBuilder", message);
    }

    private Map<String, Object> messageToResponseParameters(HttpListenerResponseBuilder httpListenerResponseBuilder, String responseBuilderParameterName, Message message) {
        if (message.getAttributes() instanceof HttpResponseAttributes) {
            HttpResponseAttributes httpResponseAttributes = (HttpResponseAttributes)message.getAttributes();
            httpListenerResponseBuilder.setBody(message.getPayload().getValue());
            httpListenerResponseBuilder.setHeaders((Map<String, String>)httpResponseAttributes.getHeaders());
            httpListenerResponseBuilder.setStatusCode(httpResponseAttributes.getStatusCode());
            httpListenerResponseBuilder.setReasonPhrase(httpResponseAttributes.getReasonPhrase());
            return ImmutableMap.builder().put((Object)responseBuilderParameterName, (Object)httpListenerResponseBuilder).build();
        }
        if (message.getAttributes() instanceof HttpPolicyResponseAttributes) {
            HttpPolicyResponseAttributes httpResponseAttributes = (HttpPolicyResponseAttributes)message.getAttributes();
            httpListenerResponseBuilder.setBody(message.getPayload().getValue());
            httpListenerResponseBuilder.setHeaders(httpResponseAttributes.getHeaders());
            httpListenerResponseBuilder.setStatusCode(httpResponseAttributes.getStatusCode());
            httpListenerResponseBuilder.setReasonPhrase(httpResponseAttributes.getReasonPhrase());
            return ImmutableMap.builder().put((Object)responseBuilderParameterName, (Object)httpListenerResponseBuilder).build();
        }
        return Collections.emptyMap();
    }
}

