/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.client;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.requester.HttpRequestOperationConfig;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.api.requester.HttpRequesterConfigBuilder;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.module.http.internal.request.SuccessStatusCodeValidator;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactory;

public class HttpRequesterBuilder
implements HttpRequestOperationConfig<HttpRequesterBuilder> {
    public static final String DEFAULT_HTTP_REQUEST_CONFIG_NAME = "_muleDefaultHttpRequestConfig";
    private static final Object REGISTRY_LOCK = new Object();
    private final DefaultHttpRequester httpRequester;
    private final MuleContext muleContext;
    private TlsContextFactory tlsContextFactory;

    public HttpRequesterBuilder(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.httpRequester = new DefaultHttpRequester();
        this.httpRequester.setMuleContext(muleContext);
    }

    public HttpRequesterBuilder setHost(String host) {
        this.httpRequester.setHost(host);
        return this;
    }

    public HttpRequesterBuilder setPort(String port) {
        this.httpRequester.setPort(port);
        return this;
    }

    public HttpRequesterBuilder setPath(String path) {
        this.httpRequester.setPath(path);
        return this;
    }

    @Override
    public HttpRequesterBuilder method(String method) {
        this.httpRequester.setMethod(method);
        return this;
    }

    @Override
    public HttpRequesterBuilder enableFollowsRedirect() {
        this.httpRequester.setFollowRedirects(Boolean.TRUE.toString());
        return this;
    }

    @Override
    public HttpRequesterBuilder disableFollowsRedirect() {
        this.httpRequester.setFollowRedirects(Boolean.FALSE.toString());
        return this;
    }

    @Override
    public HttpRequesterBuilder requestStreamingMode(HttpStreamingType mode) {
        this.httpRequester.setRequestStreamingMode(mode.name());
        return this;
    }

    @Override
    public HttpRequesterBuilder requestConfig(HttpRequesterConfig requestConfig) {
        this.httpRequester.setConfig((DefaultHttpRequesterConfig)requestConfig);
        return this;
    }

    @Override
    public HttpRequesterBuilder disableStatusCodeValidation() {
        this.httpRequester.setResponseValidator(SuccessStatusCodeValidator.NULL_VALIDATOR);
        return this;
    }

    @Override
    public HttpRequesterBuilder disableParseResponse() {
        this.httpRequester.setParseResponse(Boolean.FALSE.toString());
        return this;
    }

    public HttpRequesterBuilder setUrl(String url) {
        this.httpRequester.setUrl(url);
        return this;
    }

    public HttpRequesterBuilder responseTimeout(long responseTimeout) {
        this.httpRequester.setResponseTimeout(String.valueOf(responseTimeout));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultHttpRequester build() throws MuleException {
        if (this.httpRequester.getConfig() != null && this.tlsContextFactory != null) {
            throw new IllegalStateException("The request config and the TLS context factory cannot be configured at the same time");
        }
        if (this.tlsContextFactory != null) {
            String httpRequesterWithTlsContextKey = "auto-generated-request-config_" + (this.tlsContextFactory instanceof DefaultTlsContextFactory ? ((DefaultTlsContextFactory)this.tlsContextFactory).getName() : this.tlsContextFactory.toString());
            DefaultHttpRequesterConfig requestConfig = (DefaultHttpRequesterConfig)this.muleContext.getRegistry().get(httpRequesterWithTlsContextKey);
            if (requestConfig == null) {
                Object object = REGISTRY_LOCK;
                synchronized (object) {
                    requestConfig = (DefaultHttpRequesterConfig)this.muleContext.getRegistry().get(httpRequesterWithTlsContextKey);
                    if (requestConfig == null) {
                        requestConfig = (DefaultHttpRequesterConfig)new HttpRequesterConfigBuilder(this.muleContext).setProtocol(HttpConstants.Protocols.HTTPS).setTlsContext(this.tlsContextFactory).build();
                        this.muleContext.getRegistry().registerObject(httpRequesterWithTlsContextKey, (Object)requestConfig);
                    }
                }
            }
            this.httpRequester.setConfig(requestConfig);
        } else if (this.httpRequester.getConfig() == null) {
            DefaultHttpRequesterConfig requestConfig = (DefaultHttpRequesterConfig)this.muleContext.getRegistry().get(DEFAULT_HTTP_REQUEST_CONFIG_NAME);
            if (requestConfig == null) {
                Object object = REGISTRY_LOCK;
                synchronized (object) {
                    requestConfig = (DefaultHttpRequesterConfig)this.muleContext.getRegistry().get(DEFAULT_HTTP_REQUEST_CONFIG_NAME);
                    if (requestConfig == null) {
                        requestConfig = (DefaultHttpRequesterConfig)new HttpRequesterConfigBuilder(this.muleContext).build();
                        this.muleContext.getRegistry().registerObject(DEFAULT_HTTP_REQUEST_CONFIG_NAME, (Object)requestConfig);
                    }
                }
            } else {
                requestConfig.start();
            }
            this.httpRequester.setConfig(requestConfig);
        }
        this.httpRequester.initialise();
        return this.httpRequester;
    }

    public HttpRequesterBuilder setOperationConfig(HttpRequestOptions operationOptions) {
        if (operationOptions.getMethod() != null) {
            this.httpRequester.setMethod(operationOptions.getMethod());
        }
        if (operationOptions.isFollowsRedirect() != null && !operationOptions.isFollowsRedirect().booleanValue()) {
            this.httpRequester.setFollowRedirects(operationOptions.isFollowsRedirect().toString());
        }
        if (operationOptions.getRequestStreamingMode() != null) {
            this.httpRequester.setRequestStreamingMode(operationOptions.getRequestStreamingMode().name());
        }
        if (operationOptions.getRequesterConfig() != null) {
            this.httpRequester.setConfig((DefaultHttpRequesterConfig)operationOptions.getRequesterConfig());
        }
        if (operationOptions.isStatusCodeValidationDisabled()) {
            this.httpRequester.setResponseValidator(SuccessStatusCodeValidator.NULL_VALIDATOR);
        }
        if (operationOptions.isParseResponseDisabled()) {
            this.httpRequester.setParseResponse(Boolean.FALSE.toString());
        }
        if (operationOptions.getResponseTimeout() != null) {
            this.httpRequester.setResponseTimeout(String.valueOf(operationOptions.getResponseTimeout()));
        }
        this.tlsContextFactory = operationOptions.getTlsContextFactory();
        return this;
    }
}

