/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.mule.module.http.internal.listener.HttpListenerRegistry;
import org.mule.module.http.internal.listener.RequestHandlerManager;
import org.mule.module.http.internal.listener.Server;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.matcher.ListenerRequestMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyServer
implements Server {
    private Logger LOGGER = LoggerFactory.getLogger(GrizzlyServer.class);
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpListenerRegistry listenerRegistry;
    private final Supplier<Long> shutdownTimeoutSupplier;
    private TCPNIOServerConnection serverConnection;
    private boolean stopped = true;
    private boolean stopping;
    private boolean shouldWaitConnectionsOnStop;
    private final Object openConnectionsSync = new Object();
    private volatile int openConnections = 0;

    public GrizzlyServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Long> shutdownTimeout) {
        this.serverAddress = serverAddress;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
        this.shutdownTimeoutSupplier = shutdownTimeout;
    }

    @Override
    public synchronized void start() throws IOException {
        this.transport.getConnectionMonitoringConfig().addProbes((Object[])new ConnectionProbe[]{new ConnectionProbe.Adapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAcceptEvent(Connection serverConnection, Connection clientConnection) {
                Object object = GrizzlyServer.this.openConnectionsSync;
                synchronized (object) {
                    GrizzlyServer.this.openConnections = GrizzlyServer.this.openConnections + 1;
                }
                clientConnection.getMonitoringConfig().addProbes(new Object[]{new ConnectionProbe.Adapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onCloseEvent(Connection connection) {
                        Object object = GrizzlyServer.this.openConnectionsSync;
                        synchronized (object) {
                            GrizzlyServer.this.openConnections = GrizzlyServer.this.openConnections - 1;
                            if (GrizzlyServer.this.openConnections == 0) {
                                GrizzlyServer.this.openConnectionsSync.notifyAll();
                            }
                        }
                    }
                }});
            }
        }});
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.stopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        block11: {
            if (this.stopped) {
                return;
            }
            this.stopping = true;
            Long shutdownTimeout = (Long)this.shutdownTimeoutSupplier.get();
            long stopNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(shutdownTimeout);
            try {
                this.transport.unbind((Connection)this.serverConnection);
                if (!this.shouldWaitConnectionsOnStop || shutdownTimeout == 0L) break block11;
                Object object = this.openConnectionsSync;
                synchronized (object) {
                    long remainingMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - System.nanoTime());
                    while (this.openConnections != 0 && remainingMillis > 0L) {
                        this.openConnectionsSync.wait(Math.min(remainingMillis, 50L));
                        remainingMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - System.nanoTime());
                    }
                    if (this.openConnections != 0) {
                        this.LOGGER.warn("There are still {} open connections on server stop.", (Object)this.openConnections);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.stopped = true;
                this.stopping = false;
            }
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public RequestHandlerManager addRequestHandler(ListenerRequestMatcher listenerRequestMatcher, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, listenerRequestMatcher);
    }

    public void setWaitConnectionsOnStop(boolean value) {
        this.shouldWaitConnectionsOnStop = value;
    }
}

