/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.OutputHandler;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.HttpMessageBuilder;
import org.mule.module.http.internal.HttpParamType;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.EmptyHttpEntity;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.HttpProtocol;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.OutputHandlerHttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.HttpResponseHeaderBuilder;
import org.mule.module.http.internal.multipart.HttpMultipartEncoder;
import org.mule.module.http.internal.multipart.HttpPartDataSource;
import org.mule.transport.NullPayload;
import org.mule.util.AttributeEvaluator;
import org.mule.util.DataTypeUtils;
import org.mule.util.NumberUtils;
import org.mule.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseBuilder
extends HttpMessageBuilder
implements Initialisable,
MuleContextAware {
    public static final String MULTIPART = "multipart";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String statusCode;
    private String reasonPhrase;
    private boolean disablePropertiesAsHeaders = false;
    private HttpStreamingType responseStreaming = HttpStreamingType.AUTO;
    private boolean multipartEntityWithNoMultipartContentTypeWarned;
    private boolean mapPayloadButNoUrlEncodedContentTypeWarned;
    private AttributeEvaluator statusCodeEvaluator;
    private AttributeEvaluator reasonPhraseEvaluator;
    private MuleContext muleContext;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.init();
    }

    void init() throws InitialisationException {
        this.statusCodeEvaluator = new AttributeEvaluator(this.statusCode).initialize(this.muleContext.getExpressionManager());
        this.reasonPhraseEvaluator = new AttributeEvaluator(this.reasonPhrase).initialize(this.muleContext.getExpressionManager());
    }

    public HttpResponse build(org.mule.module.http.internal.domain.response.HttpResponseBuilder httpResponseBuilder, MuleEvent event, String httpVersion) throws MessagingException {
        String resolvedReasonPhrase;
        HttpEntity httpEntity;
        DataType dataType;
        HttpResponseHeaderBuilder httpResponseHeaderBuilder = new HttpResponseHeaderBuilder();
        Set outboundProperties = event.getMessage().getOutboundPropertyNames();
        if (!this.disablePropertiesAsHeaders) {
            for (Object outboundPropertyName : outboundProperties) {
                if (!this.isNotIgnoredProperty((String)outboundPropertyName)) continue;
                Object outboundPropertyValue = event.getMessage().getOutboundProperty((String)outboundPropertyName);
                httpResponseHeaderBuilder.addHeader((String)outboundPropertyName, outboundPropertyValue);
            }
        }
        if (!outboundProperties.contains("Content-Type") && event.getMessage().getPayload() != NullPayload.getInstance() && !"*/*".equals((dataType = event.getMessage().getDataType()).getMimeType())) {
            httpResponseHeaderBuilder.addHeader("Content-Type", DataTypeUtils.getContentType((DataType)dataType));
        }
        ParameterMap resolvedHeaders = this.resolveParams(event, HttpParamType.HEADER);
        if (HttpResponseBuilder.shouldIncludeConnectionClose(this.muleContext)) {
            resolvedHeaders.remove("Connection");
            resolvedHeaders.put("Connection", "close");
        }
        for (String name : resolvedHeaders.keySet()) {
            List<String> paramValues = resolvedHeaders.getAll(name);
            for (String value : paramValues) {
                if ("Transfer-Encoding".equals(name) && !this.supportsTransferEncoding(event)) {
                    this.logger.debug("Client HTTP version is lower than 1.1 so the unsupported 'Transfer-Encoding' header has been removed and 'Content-Length' will be sent instead.");
                    continue;
                }
                httpResponseHeaderBuilder.addHeader(name, value);
            }
        }
        String configuredContentType = httpResponseHeaderBuilder.getContentType();
        String existingTransferEncoding = httpResponseHeaderBuilder.getTransferEncoding();
        String existingContentLength = httpResponseHeaderBuilder.getContentLength();
        if (!event.getMessage().getOutboundAttachmentNames().isEmpty()) {
            if (configuredContentType == null) {
                httpResponseHeaderBuilder.addContentType(this.createMultipartFormDataContentType());
            } else if (!configuredContentType.startsWith(MULTIPART)) {
                this.warnNoMultipartContentTypeButMultipartEntity(httpResponseHeaderBuilder.getContentType());
            }
            httpEntity = this.createMultipartEntity(event, httpResponseHeaderBuilder.getContentType());
            this.resolveEncoding(httpResponseHeaderBuilder, existingTransferEncoding, existingContentLength, this.supportsTransferEncoding(event), (ByteArrayHttpEntity)httpEntity);
        } else {
            Object payload = event.getMessage().getPayload();
            if (payload == NullPayload.getInstance()) {
                this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0);
                httpEntity = new EmptyHttpEntity();
            } else if (payload instanceof Map) {
                if (configuredContentType == null) {
                    httpResponseHeaderBuilder.addContentType("application/x-www-form-urlencoded");
                } else if (!configuredContentType.startsWith("application/x-www-form-urlencoded")) {
                    this.warnMapPayloadButNoUrlEncodedContentType(httpResponseHeaderBuilder.getContentType());
                }
                httpEntity = this.createUrlEncodedEntity(event, (Map)payload);
                if (this.responseStreaming == HttpStreamingType.ALWAYS && this.supportsTransferEncoding(event)) {
                    this.setupChunkedEncoding(httpResponseHeaderBuilder);
                } else if (httpEntity instanceof EmptyHttpEntity) {
                    this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0);
                } else {
                    ByteArrayHttpEntity byteArrayHttpEntity = (ByteArrayHttpEntity)httpEntity;
                    this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
                }
            } else {
                ByteArrayHttpEntity byteArrayHttpEntity;
                boolean isStream = payload instanceof InputStream;
                if (isStream || payload instanceof OutputHandler) {
                    if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null) {
                        if (this.supportsTransferEncoding(event, httpVersion)) {
                            this.setupChunkedEncoding(httpResponseHeaderBuilder);
                        }
                        httpEntity = isStream ? new InputStreamHttpEntity((InputStream)payload) : new OutputHandlerHttpEntity((OutputHandler)payload);
                    } else {
                        try {
                            byteArrayHttpEntity = new ByteArrayHttpEntity((byte[])event.getMessage().getPayload(DataType.BYTE_ARRAY_DATA_TYPE));
                            this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
                            httpEntity = byteArrayHttpEntity;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else {
                    try {
                        byteArrayHttpEntity = new ByteArrayHttpEntity((byte[])event.getMessage().getPayload(DataType.BYTE_ARRAY_DATA_TYPE));
                        this.resolveEncoding(httpResponseHeaderBuilder, existingTransferEncoding, existingContentLength, this.supportsTransferEncoding(event), byteArrayHttpEntity);
                        httpEntity = byteArrayHttpEntity;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Integer resolvedStatusCode = this.resolveStatusCode(event);
        if (resolvedStatusCode != null) {
            httpResponseBuilder.setStatusCode(resolvedStatusCode);
            if (resolvedStatusCode.intValue() == HttpConstants.HttpStatus.NO_CONTENT.getStatusCode()) {
                httpEntity = new EmptyHttpEntity();
                httpResponseHeaderBuilder.removeHeader("Transfer-Encoding");
            }
        }
        if ((resolvedReasonPhrase = this.resolveReasonPhrase(event, resolvedStatusCode)) != null) {
            httpResponseBuilder.setReasonPhrase(resolvedReasonPhrase);
        }
        Collection<String> headerNames = httpResponseHeaderBuilder.getHeaderNames();
        for (String headerName : headerNames) {
            Collection<String> values = httpResponseHeaderBuilder.getHeader(headerName);
            for (String value : values) {
                httpResponseBuilder.addHeader(headerName, value);
            }
        }
        httpResponseBuilder.setEntity(httpEntity);
        return httpResponseBuilder.build();
    }

    private static boolean shouldIncludeConnectionClose(MuleContext muleContext) {
        return muleContext != null && (!muleContext.isStarted() || muleContext.isStopping() || muleContext.isStopped());
    }

    private boolean supportsTransferEncoding(MuleEvent event) {
        String httpVersion = (String)event.getMessage().getInboundProperty("http.version");
        return !HttpProtocol.HTTP_0_9.asString().equals(httpVersion) && !HttpProtocol.HTTP_1_0.asString().equals(httpVersion);
    }

    private boolean supportsTransferEncoding(MuleEvent event, String httpOriginalVersion) {
        String httpVersion = (String)event.getMessage().getInboundProperty("http.version");
        if (httpVersion == null) {
            httpVersion = httpOriginalVersion;
        }
        return !HttpProtocol.HTTP_0_9.asString().equals(httpVersion) && !HttpProtocol.HTTP_1_0.asString().equals(httpVersion);
    }

    private void resolveEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, String existingTransferEncoding, String existingContentLength, boolean supportsTranferEncoding, ByteArrayHttpEntity byteArrayHttpEntity) {
        if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null && "chunked".equals(existingTransferEncoding)) {
            if (supportsTranferEncoding) {
                this.setupChunkedEncoding(httpResponseHeaderBuilder);
            }
        } else {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getContent().length);
        }
    }

    private boolean isNotIgnoredProperty(String outboundPropertyName) {
        return !outboundPropertyName.startsWith("http.") && !outboundPropertyName.equalsIgnoreCase("Connection") && !outboundPropertyName.equalsIgnoreCase("Transfer-Encoding");
    }

    private void setupContentLengthEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, int contentLength) {
        if (httpResponseHeaderBuilder.getTransferEncoding() != null) {
            this.logger.debug("Content-Length encoding is being used so the 'Transfer-Encoding' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Transfer-Encoding");
        }
        httpResponseHeaderBuilder.setContentLength(String.valueOf(contentLength));
    }

    private void setupChunkedEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        if (httpResponseHeaderBuilder.getContentLength() != null) {
            this.logger.debug("Chunked encoding is being used so the 'Content-Length' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Content-Length");
        }
        httpResponseHeaderBuilder.addHeader("Transfer-Encoding", "chunked");
    }

    private Integer resolveStatusCode(MuleEvent event) {
        if (this.statusCode != null) {
            return this.statusCodeEvaluator.resolveIntegerValue(event);
        }
        Object statusCodeOutboundProperty = event.getMessage().getOutboundProperty("http.status");
        if (statusCodeOutboundProperty != null) {
            return NumberUtils.toInt((Object)statusCodeOutboundProperty);
        }
        return null;
    }

    private String resolveReasonPhrase(MuleEvent event, Integer resolvedStatusCode) {
        if (this.reasonPhrase != null) {
            return this.reasonPhraseEvaluator.resolveStringValue(event);
        }
        Object reasonPhraseOutboundProperty = event.getMessage().getOutboundProperty("http.reason");
        if (reasonPhraseOutboundProperty != null) {
            return reasonPhraseOutboundProperty.toString();
        }
        if (resolvedStatusCode != null) {
            return HttpConstants.HttpStatus.getReasonPhraseForStatusCode(resolvedStatusCode);
        }
        return null;
    }

    private String createMultipartFormDataContentType() {
        return String.format("%s; boundary=%s", "multipart/form-data", UUID.getUUID());
    }

    private HttpEntity createUrlEncodedEntity(MuleEvent event, Map payload) {
        Map mapPayload = payload;
        ByteArrayHttpEntity entity = new EmptyHttpEntity();
        if (!mapPayload.isEmpty()) {
            String encodedBody = mapPayload instanceof ParameterMap ? HttpParser.encodeString(event.getEncoding(), ((ParameterMap)mapPayload).toListValuesMap()) : HttpParser.encodeString(event.getEncoding(), mapPayload);
            entity = new ByteArrayHttpEntity(encodedBody.getBytes());
        }
        return entity;
    }

    private void warnMapPayloadButNoUrlEncodedContentType(String contentType) {
        if (!this.mapPayloadButNoUrlEncodedContentTypeWarned) {
            this.logger.warn(String.format("Payload is a Map which will be used to generate an url encoded http body but Content-Type specified is %s and not %s", contentType, "application/x-www-form-urlencoded"));
            this.mapPayloadButNoUrlEncodedContentTypeWarned = true;
        }
    }

    private void warnNoMultipartContentTypeButMultipartEntity(String contentType) {
        if (!this.multipartEntityWithNoMultipartContentTypeWarned) {
            this.logger.warn(String.format("Sending http response with Content-Type %s but the message has attachment and a multipart entity is generated", contentType));
            this.multipartEntityWithNoMultipartContentTypeWarned = true;
        }
    }

    private HttpEntity createMultipartEntity(MuleEvent event, String contentType) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message contains outbound attachments. Ignoring payload and trying to generate multipart response");
        }
        LinkedHashMap<String, DataHandler> parts = new LinkedHashMap<String, DataHandler>();
        for (String outboundAttachmentName : event.getMessage().getOutboundAttachmentNames()) {
            parts.put(outboundAttachmentName, event.getMessage().getOutboundAttachment(outboundAttachmentName));
        }
        try {
            MultipartHttpEntity multipartEntity = new MultipartHttpEntity(HttpPartDataSource.createFrom(parts));
            return new ByteArrayHttpEntity(HttpMultipartEncoder.createMultipartContent(multipartEntity, contentType));
        }
        catch (Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    public static HttpResponseBuilder emptyInstance(MuleContext muleContext) throws InitialisationException {
        HttpResponseBuilder httpResponseBuilder = new HttpResponseBuilder();
        httpResponseBuilder.setMuleContext(muleContext);
        httpResponseBuilder.init();
        return httpResponseBuilder;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setDisablePropertiesAsHeaders(boolean disablePropertiesAsHeaders) {
        this.disablePropertiesAsHeaders = disablePropertiesAsHeaders;
    }

    public void setResponseStreaming(HttpStreamingType responseStreaming) {
        this.responseStreaming = responseStreaming;
    }

    public HttpStreamingType getResponseStreaming() {
        return this.responseStreaming;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

