/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.CaseInsensitiveMapWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseHeaderBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseHeaderBuilder.class);
    private List<String> calculatedHeadersNames = Arrays.asList("Transfer-Encoding", "Content-Length");
    private List<String> uniqueHeadersNames = Arrays.asList("Transfer-Encoding".toLowerCase(), "Content-Length".toLowerCase(), "Content-Type".toLowerCase());
    Multimap<String, String> headers = Multimaps.newMultimap((Map)new CaseInsensitiveMapWrapper(HashMap.class, new Object[0]), (Supplier)new Supplier<Collection<String>>(){

        public Collection<String> get() {
            return Sets.newHashSet();
        }
    });

    public void addHeader(String headerName, Object headerValue) {
        if (headerValue instanceof Iterable) {
            this.failIfHeaderDoesNotSupportMultipleValues(headerName);
            Iterable values = (Iterable)headerValue;
            for (Object value : values) {
                this.addSimpleValue(headerName, value.toString());
            }
        } else if (headerValue instanceof String[]) {
            String[] values;
            this.failIfHeaderDoesNotSupportMultipleValues(headerName);
            for (String value : values = (String[])headerValue) {
                this.addSimpleValue(headerName, value);
            }
        } else {
            this.addSimpleValue(headerName, headerValue.toString());
        }
    }

    public Collection<String> removeHeader(String headerName) {
        return this.headers.removeAll((Object)headerName);
    }

    private void failIfHeaderDoesNotSupportMultipleValues(String headerName) {
        if (this.calculatedHeadersNames.contains(headerName)) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Header: " + headerName + " does not support multiple values")));
        }
    }

    private void logIfHeaderDoesNotSupportMultipleValues(String headerName) {
        if (this.uniqueHeadersNames.contains(headerName.toLowerCase())) {
            Collection values = this.headers.removeAll((Object)headerName);
            LOGGER.warn("Header: " + headerName + " does not support multiple values. Removing {}", (Object)values);
        }
    }

    private void addSimpleValue(String headerName, String headerValue) {
        if (this.headers.containsKey((Object)headerName)) {
            this.logIfHeaderDoesNotSupportMultipleValues(headerName);
        }
        this.headers.put((Object)headerName, (Object)headerValue);
    }

    public String getContentType() {
        return this.getSimpleValue("Content-Type");
    }

    public String getTransferEncoding() {
        return this.getSimpleValue("Transfer-Encoding");
    }

    public String getContentLength() {
        return this.getSimpleValue("Content-Length");
    }

    private String getSimpleValue(String header) {
        if (!this.headers.containsKey((Object)header)) {
            return null;
        }
        return (String)this.headers.get((Object)header).iterator().next();
    }

    public void addContentType(String multipartFormData) {
        this.addSimpleValue("Content-Type", multipartFormData);
    }

    public void setContentLenght(String calculatedContentLenght) {
        this.removeHeader("Content-Length");
        this.addSimpleValue("Content-Length", calculatedContentLenght);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeader(String headerName) {
        return this.headers.get((Object)headerName);
    }
}

