/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.api.client;

import org.mule.api.client.AbstractBaseOptionsBuilder;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.request.client.DefaultHttpRequestOptions;
import org.mule.transport.ssl.api.TlsContextFactory;

public class HttpRequestOptionsBuilder
extends AbstractBaseOptionsBuilder<HttpRequestOptionsBuilder, HttpRequestOptions> {
    private String method;
    private Boolean followsRedirect;
    private HttpStreamingType requestStreamingMode;
    private HttpRequesterConfig requestConfig;
    private boolean disableStatusCodeValidation;
    private boolean disableParseResponse;
    private TlsContextFactory tlsContextFactory;

    private HttpRequestOptionsBuilder() {
    }

    public HttpRequestOptionsBuilder method(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestOptionsBuilder enableFollowsRedirect() {
        this.followsRedirect = true;
        return this;
    }

    public HttpRequestOptionsBuilder disableFollowsRedirect() {
        this.followsRedirect = false;
        return this;
    }

    public HttpRequestOptionsBuilder requestStreamingMode(HttpStreamingType mode) {
        this.requestStreamingMode = mode;
        return this;
    }

    public HttpRequestOptionsBuilder requestConfig(HttpRequesterConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    public HttpRequestOptionsBuilder disableStatusCodeValidation() {
        this.disableStatusCodeValidation = true;
        return this;
    }

    public HttpRequestOptionsBuilder disableParseResponse() {
        this.disableParseResponse = true;
        return this;
    }

    public HttpRequestOptionsBuilder tlsContextFactory(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
        return this;
    }

    public HttpRequestOptions build() {
        return new DefaultHttpRequestOptions(this.method, this.followsRedirect, this.requestStreamingMode, this.requestConfig, this.disableStatusCodeValidation, this.disableParseResponse, this.tlsContextFactory, this.getResponseTimeout());
    }

    public static HttpRequestOptionsBuilder newOptions() {
        return new HttpRequestOptionsBuilder();
    }
}

