/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.util.Collection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.mule.module.http.internal.domain.response.HttpResponse;

public abstract class BaseResponseCompletionHandler
extends EmptyCompletionHandler<WriteResult> {
    protected HttpResponsePacket buildHttpResponsePacket(HttpRequestPacket sourceRequest, HttpResponse httpResponse) {
        HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)sourceRequest).status(httpResponse.getStatusCode()).reasonPhrase(httpResponse.getReasonPhrase());
        Collection<String> allHeaders = httpResponse.getHeaderNames();
        for (String headerName : allHeaders) {
            Collection<String> values = httpResponse.getHeaderValues(headerName);
            for (String value : values) {
                responsePacketBuilder.header(headerName, value);
            }
        }
        HttpResponsePacket httpResponsePacket = responsePacketBuilder.build();
        httpResponsePacket.setProtocol(sourceRequest.getProtocol());
        if (httpResponse.getHeaderValueIgnoreCase("Transfer-Encoding") != null) {
            httpResponsePacket.setChunked(true);
        }
        if ("close".equalsIgnoreCase(httpResponsePacket.getHeader("Connection"))) {
            httpResponsePacket.getProcessingState().setKeepAlive(false);
        }
        return httpResponsePacket;
    }
}

