/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.mule.api.MuleRuntimeException;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.util.StringUtils;

public class HttpParser {
    private static final String SPACE_ENTITY = "%20";
    private static final String PLUS_SIGN = "\\+";
    private static final String CONTENT_DISPOSITION_PART_HEADER = "Content-Disposition";
    private static final String NAME_ATTRIBUTE = "name";

    public static String extractPath(String uri) {
        String path = uri;
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public static String extractQueryParams(String uri) {
        int i = uri.indexOf("?");
        String queryString = "";
        if (i > -1) {
            queryString = uri.substring(i + 1);
        }
        return queryString;
    }

    public static Collection<Part> parseMultipartContent(InputStream content, String contentType) throws IOException {
        MimeMultipart mimeMultipart = null;
        ArrayList parts = Lists.newArrayList();
        try {
            mimeMultipart = new MimeMultipart((DataSource)new ByteArrayDataSource(content, contentType));
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        try {
            int partCount = mimeMultipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart part = mimeMultipart.getBodyPart(i);
                String partName = part.getFileName();
                String contentDisposition = part.getHeader(CONTENT_DISPOSITION_PART_HEADER)[0];
                if (contentDisposition.contains(NAME_ATTRIBUTE)) {
                    partName = contentDisposition.substring(contentDisposition.indexOf(NAME_ATTRIBUTE) + NAME_ATTRIBUTE.length() + 2);
                    partName = partName.substring(0, partName.indexOf("\""));
                }
                HttpPart httpPart = new HttpPart(partName, IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), part.getSize());
                Enumeration headers = part.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    httpPart.addHeader(header.getName(), header.getValue());
                }
                parts.add(httpPart);
            }
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
        return parts;
    }

    public static String sanitizePathWithStartSlash(String path) {
        if (path == null) {
            return null;
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public static ParameterMap decodeQueryString(String queryString) {
        return HttpParser.decodeUrlEncodedBody(queryString, Charsets.UTF_8.name());
    }

    public static String encodeQueryString(Map parameters) {
        return HttpParser.encodeString(Charsets.UTF_8.name(), parameters);
    }

    public static ParameterMap decodeUrlEncodedBody(String urlEncodedBody, String encoding) {
        return HttpParser.decodeString(urlEncodedBody, encoding);
    }

    public static ParameterMap decodeString(String encodedString, String encoding) {
        ParameterMap queryParams = new ParameterMap();
        if (!StringUtils.isBlank((String)encodedString)) {
            String[] pairs;
            for (String pair : pairs = encodedString.split("&")) {
                int idx = pair.indexOf("=");
                if (idx != -1) {
                    HttpParser.addParam(queryParams, pair.substring(0, idx), pair.substring(idx + 1), encoding);
                    continue;
                }
                HttpParser.addParam(queryParams, pair, null, encoding);
            }
        }
        return queryParams;
    }

    private static void addParam(ParameterMap queryParams, String name, String value, String encoding) {
        queryParams.put(HttpParser.decode(name, encoding), HttpParser.decode(value, encoding));
    }

    public static String encodeString(String encoding, Map parameters) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : parameters.entrySet()) {
            String paramName = entry.getKey().toString();
            Object paramValue = entry.getValue();
            List<Object> paramValues = paramValue instanceof Iterable ? (List<Object>)paramValue : Arrays.asList(paramValue);
            for (Object t : paramValues) {
                try {
                    paramName = URLEncoder.encode(paramName, encoding);
                    paramValue = t != null ? URLEncoder.encode(t.toString(), encoding) : null;
                }
                catch (UnsupportedEncodingException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
                if (result.length() > 0) {
                    result.append("&");
                }
                result.append(paramName);
                if (paramValue == null) continue;
                result.append("=");
                result.append(paramValue);
            }
        }
        String body = result.toString();
        return body;
    }

    public static ParameterMap decodeUriParams(String pathWithUriParams, String requestPath) {
        ParameterMap uriParams = new ParameterMap();
        if (pathWithUriParams.contains("{")) {
            String[] requestPathParts = requestPath.split("/");
            String[] listenerPathParts = pathWithUriParams.split("/");
            int longerPathSize = Math.min(requestPathParts.length, listenerPathParts.length);
            for (int i = 1; i < longerPathSize; ++i) {
                String listenerPart = listenerPathParts[i];
                if (!listenerPart.startsWith("{") || !listenerPart.endsWith("}")) continue;
                String parameterName = listenerPart.substring(1, listenerPart.length() - 1);
                String parameterValue = requestPathParts[i];
                uriParams.put(parameterName, HttpParser.decode(parameterValue, Charsets.UTF_8.displayName()));
            }
        }
        return uriParams;
    }

    private static String decode(String text, String encoding) {
        if (text == null) {
            return null;
        }
        try {
            return URLDecoder.decode(text, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static String getContentTypeSubType(String contentType) {
        try {
            ContentType contentTypeValue = new ContentType(contentType);
            return contentTypeValue.getSubType();
        }
        catch (ParseException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static String normalizePathWithSpacesOrEncodedSpaces(String path) {
        return path.replaceAll(SPACE_ENTITY, " ").replaceAll(PLUS_SIGN, " ");
    }

    public static String encodeSpaces(String path) {
        return path.replaceAll(" ", SPACE_ENTITY);
    }
}

