/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.mule.extension.file.common.api.lock.Lock;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.extension.file.common.api.stream.LazyStreamSupplier;
import org.mule.extension.file.common.api.util.StreamProxyUtil;

public abstract class AbstractNonFinalizableFileInputStream
extends ProxyInputStream {
    private final LazyStreamSupplier streamSupplier;
    private final Lock lock;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private static InputStream createLazyStream(LazyStreamSupplier streamFactory) {
        return StreamProxyUtil.getInputStreamFromStreamFactory(streamFactory);
    }

    public AbstractNonFinalizableFileInputStream(LazyStreamSupplier streamSupplier, PathLock lock) {
        this(streamSupplier, (Lock)lock);
    }

    public AbstractNonFinalizableFileInputStream(LazyStreamSupplier streamSupplier, Lock lock) {
        super(AbstractNonFinalizableFileInputStream.createLazyStream(streamSupplier));
        this.lock = lock;
        this.streamSupplier = streamSupplier;
    }

    protected void afterRead(int n) throws IOException {
        if (n == -1) {
            this.close();
        }
    }

    public final synchronized void close() throws IOException {
        try {
            if (this.closed.compareAndSet(false, true) && this.streamSupplier.isSupplied()) {
                this.doClose();
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void doClose() throws IOException {
        this.in.close();
        this.in = new ClosedInputStream();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

