/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.matcher;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.mule.extension.file.common.api.PredicateType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;

public final class PathMatcherPredicate
implements Predicate<String> {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";
    private final Predicate<String> delegate;

    public PathMatcherPredicate(String pattern) {
        this.delegate = this.getPredicateForFilename(pattern, PredicateType.LOCAL_FILE_SYSTEM, true);
    }

    public PathMatcherPredicate(String pattern, PredicateType predicateType, boolean caseSensitive) {
        this.delegate = this.getPredicateForFilename(pattern, predicateType, caseSensitive);
    }

    @Override
    public boolean test(String path) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)path) ? 1 : 0) != 0, (String)"Cannot match a blank filename");
        return this.delegate.test(path);
    }

    private Predicate<String> getPredicateForFilename(String pattern, PredicateType predicateType, boolean caseSensitive) {
        if (pattern.startsWith(REGEX_PREFIX)) {
            return Pattern.compile(this.stripRegexPrefix(pattern)).asPredicate();
        }
        if (pattern.startsWith(GLOB_PREFIX)) {
            return predicateType.getPredicate(pattern, caseSensitive);
        }
        return predicateType.getPredicate(GLOB_PREFIX + pattern, caseSensitive);
    }

    private String stripRegexPrefix(String pattern) {
        return pattern.replaceAll(REGEX_PREFIX, "");
    }
}

