/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.lock;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.extension.file.common.api.lock.UriLock;
import org.mule.runtime.api.lock.LockFactory;

public class URLPathLock
implements PathLock,
UriLock {
    private final URL url;
    private final LockFactory lockFactory;
    private final AtomicReference<Lock> ownedLock = new AtomicReference();

    public URLPathLock(URL url, LockFactory lockFactory) {
        this.url = url;
        this.lockFactory = lockFactory;
    }

    @Override
    public boolean tryLock() {
        Lock lock = this.getLock();
        if (lock.tryLock()) {
            this.ownedLock.set(lock);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLocked() {
        if (this.ownedLock.get() != null) {
            return true;
        }
        Lock lock = this.getLock();
        try {
            boolean bl = !lock.tryLock();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void release() {
        Lock lock = this.ownedLock.getAndSet(null);
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    private Lock getLock() {
        return this.lockFactory.createLock(this.url.toExternalForm());
    }

    @Override
    public Path getPath() {
        try {
            return Paths.get(this.url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI getUri() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

