/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.command;

import java.nio.file.Path;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.command.AbstractFileCommand;
import org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileCommand<F extends FileSystem>
extends AbstractFileCommand<F, Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileCommand.class);

    protected FileCommand(F fileSystem) {
        super(fileSystem);
    }

    @Override
    protected String pathToString(Path path) {
        return path.toString();
    }

    @Override
    protected Path getAbsolutePath(Path path) {
        return path.toAbsolutePath();
    }

    @Override
    protected Path getParent(Path path) {
        return path.getParent();
    }

    @Override
    protected Path resolvePath(Path basePath, String filePath) {
        return basePath.resolve(filePath);
    }

    @Override
    protected abstract boolean exists(Path var1);

    @Override
    protected abstract Path getBasePath(FileSystem var1);

    @Override
    protected abstract void doMkDirs(Path var1);

    @Override
    protected void assureParentFolderExists(Path path, boolean createParentFolder) {
        super.assureParentFolderExists(path, createParentFolder);
    }

    @Override
    protected void mkdirs(Path directoryPath) {
        super.mkdirs(directoryPath);
    }

    @Override
    protected Path resolvePath(String filePath) {
        return (Path)super.resolvePath(filePath);
    }

    @Override
    protected Path resolveExistingPath(String filePath) {
        return (Path)super.resolveExistingPath(filePath);
    }

    @Override
    protected IllegalPathException cannotReadDirectoryException(Path path) {
        return super.cannotReadDirectoryException(path);
    }

    @Override
    protected IllegalPathException cannotListFileException(Path path) {
        return super.cannotListFileException(path);
    }

    @Override
    protected IllegalPathException pathNotFoundException(Path path) {
        return super.pathNotFoundException(path);
    }

    @Override
    public FileAlreadyExistsException alreadyExistsException(Path path) {
        return super.alreadyExistsException(path);
    }
}

