/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.FileWriteMode;
import org.mule.extension.file.common.api.command.CopyCommand;
import org.mule.extension.file.common.api.command.CreateDirectoryCommand;
import org.mule.extension.file.common.api.command.DeleteCommand;
import org.mule.extension.file.common.api.command.ListCommand;
import org.mule.extension.file.common.api.command.MoveCommand;
import org.mule.extension.file.common.api.command.ReadCommand;
import org.mule.extension.file.common.api.command.RenameCommand;
import org.mule.extension.file.common.api.command.WriteCommand;
import org.mule.extension.file.common.api.exceptions.FileLockedException;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

public abstract class AbstractFileSystem<A extends FileAttributes>
implements FileSystem<A> {
    private final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
    @Inject
    private LockFactory lockFactory;
    private final String basePath;

    public AbstractFileSystem(String basePath) {
        this.basePath = basePath;
    }

    protected abstract ListCommand getListCommand();

    protected abstract ReadCommand getReadCommand();

    protected abstract WriteCommand getWriteCommand();

    protected abstract CopyCommand getCopyCommand();

    protected abstract MoveCommand getMoveCommand();

    protected abstract DeleteCommand getDeleteCommand();

    protected abstract RenameCommand getRenameCommand();

    protected abstract CreateDirectoryCommand getCreateDirectoryCommand();

    @Override
    @Deprecated
    public List<Result<InputStream, A>> list(FileConnectorConfig config, String directoryPath, boolean recursive, Predicate<A> matcher) {
        return this.getListCommand().list(config, directoryPath, recursive, matcher);
    }

    @Override
    public List<Result<InputStream, A>> list(FileConnectorConfig config, String directoryPath, boolean recursive, Predicate<A> matcher, Long timeBetweenSizeCheck) {
        return this.getListCommand().list(config, directoryPath, recursive, matcher, timeBetweenSizeCheck);
    }

    @Override
    @Deprecated
    public Result<InputStream, A> read(FileConnectorConfig config, String filePath, boolean lock) {
        return this.getReadCommand().read(config, filePath, lock);
    }

    @Override
    public Result<InputStream, A> read(FileConnectorConfig config, String filePath, boolean lock, Long timeBetweenSizeCheck) {
        return this.getReadCommand().read(config, filePath, lock, timeBetweenSizeCheck);
    }

    @Override
    @Deprecated
    public void write(String filePath, InputStream content, FileWriteMode mode, boolean lock, boolean createParentDirectories, String encoding) {
        this.getWriteCommand().write(filePath, content, mode, lock, createParentDirectories, encoding);
    }

    @Override
    public void write(String filePath, InputStream content, FileWriteMode mode, boolean lock, boolean createParentDirectories) {
        this.getWriteCommand().write(filePath, content, mode, lock, createParentDirectories);
    }

    @Override
    public void copy(FileConnectorConfig config, String sourcePath, String targetDirectory, boolean overwrite, boolean createParentDirectories, String renameTo) {
        this.getCopyCommand().copy(config, sourcePath, targetDirectory, overwrite, createParentDirectories, renameTo);
    }

    @Override
    public void move(FileConnectorConfig config, String sourcePath, String targetDirectory, boolean overwrite, boolean createParentDirectories, String renameTo) {
        this.getMoveCommand().move(config, sourcePath, targetDirectory, overwrite, createParentDirectories, renameTo);
    }

    @Override
    public void delete(String filePath) {
        this.getDeleteCommand().delete(filePath);
    }

    @Override
    public final void rename(String filePath, String newName, boolean overwrite) {
        this.getRenameCommand().rename(filePath, newName, overwrite);
    }

    @Override
    public void createDirectory(String directoryName) {
        this.getCreateDirectoryCommand().createDirectory(directoryName);
    }

    @Override
    public synchronized PathLock lock(Path path) {
        PathLock lock = this.createLock(path);
        this.acquireLock(lock);
        return lock;
    }

    protected void acquireLock(PathLock lock) {
        if (!lock.tryLock()) {
            throw new FileLockedException(String.format("Could not lock file '%s' because it's already owned by another process", lock.getPath()));
        }
    }

    @Override
    public MediaType getFileMessageMediaType(FileAttributes attributes) {
        return MediaType.parse((String)this.mimetypesFileTypeMap.getContentType(attributes.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLocked(Path path) {
        PathLock lock = this.createLock(path);
        try {
            boolean bl = !lock.tryLock();
            return bl;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void verifyNotLocked(Path path) {
        if (this.isLocked(path)) {
            throw new FileLockedException(String.format("File '%s' is locked by another process", path));
        }
    }

    protected abstract PathLock createLock(Path var1);

    @Override
    public Lock createMuleLock(String lockId) {
        return this.lockFactory.createLock(lockId);
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }
}

