/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public abstract class AbstractFileAttributes
implements FileAttributes,
Serializable {
    private static final long serialVersionUID = 3249780732227598L;
    @Parameter
    protected final String path;
    @Parameter
    private String fileName;

    protected AbstractFileAttributes(Path path) {
        this.path = path.toString();
        this.fileName = path.getFileName() != null ? path.getFileName().toString() : "";
    }

    protected AbstractFileAttributes(URI uri) {
        this.path = uri.getPath();
        String name = FilenameUtils.getName((String)uri.getPath());
        this.fileName = name != null ? name : "";
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    protected LocalDateTime asDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

