/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.net.URI;
import java.nio.file.Path;
import org.mule.extension.file.common.api.AbstractFileSystem;
import org.mule.extension.file.common.api.ExternalFileSystem;
import org.mule.extension.file.common.api.exceptions.FileLockedException;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.extension.file.common.api.lock.UriLock;

public abstract class AbstractExternalFileSystem
extends AbstractFileSystem
implements ExternalFileSystem {
    public AbstractExternalFileSystem(String baseUri) {
        super(baseUri);
    }

    @Override
    public final synchronized UriLock lock(URI uri) {
        UriLock lock = this.createLock(uri);
        this.acquireLock(lock);
        return lock;
    }

    protected void acquireLock(UriLock lock) {
        if (!lock.tryLock()) {
            throw new FileLockedException(String.format("Could not lock file '%s' because it's already owned by another process", lock.getUri().getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLocked(URI uri) {
        UriLock lock = this.createLock(uri);
        try {
            boolean bl = !lock.tryLock();
            return bl;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void verifyNotLocked(URI uri) {
        if (this.isLocked(uri)) {
            throw new FileLockedException(String.format("File '%s' is locked by another process", uri));
        }
    }

    protected abstract UriLock createLock(URI var1);

    @Override
    public synchronized PathLock lock(Path path) {
        throw new UnsupportedOperationException("This method is not supported for an External File System. Use lock(URI uri) instead.");
    }

    @Override
    public final void verifyNotLocked(Path path) {
        throw new UnsupportedOperationException("This method is not supported for an External File System. Use verifyNotLocked(URI uri) instead.");
    }

    @Override
    protected final boolean isLocked(Path path) {
        throw new UnsupportedOperationException("This method is not supported for an External File System. Use isLocked(URI uri) instead.");
    }

    @Override
    protected final void acquireLock(PathLock path) {
        throw new UnsupportedOperationException("This method is not supported for an External File System. Use acquireLock(URI uri) instead.");
    }

    @Override
    protected final PathLock createLock(Path path) {
        throw new UnsupportedOperationException("This method is not supported for an External File System. Use createLock(URI uri) instead.");
    }
}

