/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.matcher;

import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;

public final class PathMatcherPredicate
implements Predicate<String> {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";
    private final Predicate<String> delegate;

    public PathMatcherPredicate(String pattern) {
        this.delegate = this.getPredicateForFilename(pattern);
    }

    @Override
    public boolean test(String path) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)path) ? 1 : 0) != 0, (String)"Cannot match a blank filename");
        return this.delegate.test(path);
    }

    private Predicate<String> getPredicateForFilename(String pattern) {
        if (pattern.startsWith(REGEX_PREFIX)) {
            return Pattern.compile(this.stripRegexPrefix(pattern)).asPredicate();
        }
        if (pattern.startsWith(GLOB_PREFIX)) {
            return this.getGlobPredicate(pattern);
        }
        return this.getGlobPredicate(GLOB_PREFIX + pattern);
    }

    private Predicate<String> getGlobPredicate(String pattern) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
        return path -> matcher.matches(Paths.get(path, new String[0]));
    }

    private String stripRegexPrefix(String pattern) {
        return pattern.replaceAll(REGEX_PREFIX, "");
    }
}

