/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeTransformer;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class TypeSafeValueResolverWrapper<T>
implements ValueResolver<T> {
    private ValueResolver valueResolverDelegate;
    private Resolver<T> resolver;

    public TypeSafeValueResolverWrapper(ValueResolver valueResolverDelegate, Class<T> expectedType, MuleContext muleContext) {
        TypeSafeTransformer typeSafeTransformer = new TypeSafeTransformer(muleContext);
        this.valueResolverDelegate = valueResolverDelegate;
        this.resolver = event -> {
            Object resolvedValue = valueResolverDelegate.resolve(event);
            return ClassUtils.isInstance((Class)expectedType, resolvedValue) ? resolvedValue : typeSafeTransformer.transform(resolvedValue, DataType.fromObject(resolvedValue), DataType.fromType((Class)expectedType), event);
        };
        if (!valueResolverDelegate.isDynamic()) {
            this.resolver = new CachedResolver(this.resolver);
        }
    }

    @Override
    public T resolve(Event event) throws MuleException {
        return this.resolver.resolve(event);
    }

    @Override
    public boolean isDynamic() {
        return this.valueResolverDelegate.isDynamic();
    }

    private class CachedResolver
    implements Resolver<T> {
        private Resolver<T> resolver = event -> {
            Object resolvedValue = resolver.resolve(event);
            this.resolver = newEvent -> resolvedValue;
            return resolvedValue;
        };

        private CachedResolver(Resolver<T> resolver) {
        }

        @Override
        public T resolve(Event event) throws MuleException {
            return this.resolver.resolve(event);
        }
    }

    @FunctionalInterface
    private static interface Resolver<T> {
        public T resolve(Event var1) throws MuleException;
    }
}

