/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Set;
import java.util.function.BooleanSupplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

class ResolverUtils {
    private ResolverUtils() {
    }

    static ValueResolver<?> getFieldDefaultValueValueResolver(ObjectFieldType field, MuleContext muleContext) {
        MetadataType fieldType = field.getValue();
        String expression = (String)MetadataTypeUtils.getDefaultValue((MetadataType)field).get();
        return ResolverUtils.getExpressionBasedValueResolver(expression, fieldType, muleContext);
    }

    static ValueResolver<?> getExpressionBasedValueResolver(String expression, MetadataType metadataType, MuleContext muleContext) {
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), metadataType, muleContext);
    }

    static ValueResolver<?> getExpressionBasedValueResolver(String expression, ParameterModel operationModel, MuleContext muleContext) {
        MetadataType metadataType = operationModel.getType();
        Set modelProperties = operationModel.getModelProperties();
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType) || IntrospectionUtils.isTypedValue(modelProperties), () -> IntrospectionUtils.isParameterResolver(metadataType) || IntrospectionUtils.isParameterResolver(modelProperties), metadataType, muleContext);
    }

    private static ValueResolver<?> getExpressionBasedValueResolver(String expression, BooleanSupplier isTypedValue, BooleanSupplier isParameterResolver, MetadataType type, MuleContext muleContext) {
        if (isTypedValue.getAsBoolean()) {
            return new ExpressionTypedValueValueResolver(expression, JavaTypeUtils.getType((MetadataType)type), muleContext);
        }
        if (isParameterResolver.getAsBoolean()) {
            return new ExpressionBasedParameterResolverValueResolver(expression, type, muleContext);
        }
        if (muleContext.getExpressionManager().isExpression(expression)) {
            return new TypeSafeExpressionValueResolver(expression, JavaTypeUtils.getType((MetadataType)type), muleContext);
        }
        return new TypeSafeValueResolverWrapper(new StaticValueResolver<String>(expression), JavaTypeUtils.getType((MetadataType)type), muleContext);
    }
}

