/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.runtime.api.util.Preconditions;

public class ResolverSetResult {
    private final Map<String, Object> evaluationResult;
    private final int hashCode;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ResolverSetResult(Map<String, Object> evaluationResult, int hashCode) {
        this.evaluationResult = new HashMap<String, Object>(evaluationResult);
        this.hashCode = hashCode;
    }

    public Object get(String parameterName) {
        return this.evaluationResult.get(parameterName);
    }

    public Map<String, Object> asMap() {
        return this.evaluationResult;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResolverSetResult) {
            ResolverSetResult other = (ResolverSetResult)obj;
            return !this.evaluationResult.entrySet().stream().filter(entry -> !Objects.equal(entry.getValue(), (Object)other.get((String)entry.getKey()))).findFirst().isPresent();
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static final class Builder {
        private int hashCode = 1;
        private Map<String, Object> values = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder add(String key, Object value) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"parameter cannot be null");
            this.values.put(key, value);
            this.hashCode = 31 * this.hashCode + (value == null ? 0 : value.hashCode());
            return this;
        }

        public ResolverSetResult build() {
            return new ResolverSetResult(Collections.unmodifiableMap(this.values), this.hashCode);
        }
    }
}

