/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ImplicitConnectionProviderValueResolver
implements ConnectionProviderValueResolver {
    private ConnectionProvider connectionProvider = null;
    private Function<Event, ConnectionProvider> delegate;

    public ImplicitConnectionProviderValueResolver(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, MuleContext muleContext) {
        this.delegate = MuleExtensionUtils.getAllConnectionProviders(extensionModel, configurationModel).isEmpty() ? nextEvent -> null : event -> {
            ImplicitConnectionProviderValueResolver implicitConnectionProviderValueResolver = this;
            synchronized (implicitConnectionProviderValueResolver) {
                if (this.connectionProvider == null) {
                    this.connectionProvider = new DefaultImplicitConnectionProviderFactory().createImplicitConnectionProvider(name, extensionModel, configurationModel, (Event)event, muleContext);
                    this.delegate = nextEvent -> this.connectionProvider;
                }
                return this.connectionProvider;
            }
        };
    }

    @Override
    public ConnectionProvider resolve(Event event) throws MuleException {
        return this.delegate.apply(event);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public Optional<ResolverSet> getResolverSet() {
        return Optional.empty();
    }
}

