/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.streaming.object.Consumer;
import org.mule.runtime.core.internal.streaming.object.ConsumerIterator;
import org.mule.runtime.core.internal.streaming.object.ListConsumer;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;
import reactor.core.publisher.Mono;

public class PagedOperationMessageProcessor
extends OperationMessageProcessor {
    public PagedOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, ResolverSet resolverSet, CursorStreamProviderFactory cursorStreamProviderFactory, ExtensionManager extensionManager, PolicyManager policyManager) {
        super(extensionModel, operationModel, configurationProvider, target, resolverSet, cursorStreamProviderFactory, extensionManager, policyManager);
    }

    @Override
    protected Mono<Event> doProcess(Event event, ExecutionContextAdapter operationContext) {
        try {
            Event resultEvent = (Event)super.doProcess(event, operationContext).block();
            PagingProvider pagingProvider = (PagingProvider)resultEvent.getMessage().getPayload().getValue();
            if (pagingProvider == null) {
                throw new IllegalStateException("Obtained paging delegate cannot be null");
            }
            PagingProviderProducer producer = new PagingProviderProducer(pagingProvider, (ConfigurationInstance)operationContext.getConfiguration().get(), (ConnectionManager)this.connectionManager);
            ListConsumer consumer = new ListConsumer(producer);
            return Mono.just((Object)this.returnDelegate.asReturnValue(new ConsumerIterator((Consumer)consumer), operationContext));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }
}

