/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.NullExceptionHandler;

public final class ExceptionHandlerManager {
    private static final ExceptionHandler DEFAULT_EXCEPTION_ENRICHER = new NullExceptionHandler();
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandlerManager(ExtensionModel extensionModel, ComponentModel componentModel) {
        this.exceptionHandler = this.findExceptionHandler(extensionModel, (EnrichableModel)componentModel);
    }

    public Exception processException(Throwable t) {
        Exception handledException = this.handleException(t);
        Exception exception = this.exceptionHandler.enrichException(handledException);
        return exception != null ? exception : handledException;
    }

    public Exception handleException(Throwable e) {
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)e);
        Throwable handled = connectionException.isPresent() ? (Throwable)connectionException.get() : ExceptionUtils.extractCauseOfType((Throwable)e, UndeclaredThrowableException.class).orElse(e);
        return this.wrapInException(handled);
    }

    private Exception wrapInException(Throwable t) {
        return t instanceof Exception ? (Exception)t : new Exception(t);
    }

    private ExceptionHandler findExceptionHandler(ExtensionModel extension, EnrichableModel child) {
        return this.findExceptionHandler(child).orElseGet(() -> this.findExceptionHandler((EnrichableModel)extension).orElse(DEFAULT_EXCEPTION_ENRICHER));
    }

    private Optional<ExceptionHandler> findExceptionHandler(EnrichableModel model) {
        return model.getModelProperty(ExceptionHandlerModelProperty.class).map(p -> p.getExceptionHandlerFactory().createHandler());
    }

    ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

