/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.DynamicConfigPolicy;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderMetadataAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class DefaultConfigurationProviderFactory
implements ConfigurationProviderFactory {
    @Override
    public ConfigurationProvider createDynamicConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver, DynamicConfigPolicy dynamicConfigPolicy) throws Exception {
        this.configureConnectionProviderResolver(name, connectionProviderResolver);
        return new DynamicConfigurationProvider(name, extensionModel, configurationModel, resolverSet, connectionProviderResolver, dynamicConfigPolicy.getExpirationPolicy());
    }

    @Override
    public ConfigurationProvider createStaticConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver, MuleContext muleContext) throws Exception {
        return MuleExtensionUtils.withExtensionClassLoader(extensionModel, () -> {
            ConfigurationInstance configuration;
            this.configureConnectionProviderResolver(name, connectionProviderResolver);
            try {
                configuration = new ConfigurationInstanceFactory(extensionModel, configurationModel, resolverSet).createConfiguration(name, MuleExtensionUtils.getInitialiserEvent(muleContext), connectionProviderResolver);
            }
            catch (MuleException e) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create configuration '%s' for the '%s'", name, extensionModel.getName())), (Throwable)e);
            }
            return new ConfigurationProviderMetadataAdapter(name, extensionModel, configurationModel, configuration);
        });
    }

    private void configureConnectionProviderResolver(String configName, ValueResolver<ConnectionProvider> resolver) {
        if (resolver instanceof ConnectionProviderResolver) {
            ((ConnectionProviderResolver)resolver).setOwnerConfigName(configName);
        }
    }
}

