/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConfigurationInstanceFactory<T> {
    private static final ValueResolver<ConnectionProvider> NULL_CONNECTION_PROVIDER = new StaticValueResolver<Object>(null);
    private final ExtensionModel extensionModel;
    private final ConfigurationModel configurationModel;
    private final ConfigurationObjectBuilder<T> configurationObjectBuilder;
    private final ImplicitConnectionProviderFactory implicitConnectionProviderFactory = new DefaultImplicitConnectionProviderFactory();
    private final boolean requiresConnection;

    public ConfigurationInstanceFactory(ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet) {
        this.extensionModel = extensionModel;
        this.configurationModel = configurationModel;
        this.configurationObjectBuilder = new ConfigurationObjectBuilder(configurationModel, resolverSet);
        this.requiresConnection = !ExtensionModelUtils.getConnectedComponents((ExtensionModel)extensionModel, (ConfigurationModel)configurationModel).isEmpty();
    }

    public ConfigurationInstance createConfiguration(String name, Event event, MuleContext muleContext) throws MuleException {
        ValueResolver<Object> providerResolver = this.requiresConnection ? new StaticValueResolver<ConnectionProvider<ConnectionProvider>>(this.implicitConnectionProviderFactory.createImplicitConnectionProvider(name, this.extensionModel, this.configurationModel, event, muleContext)) : NULL_CONNECTION_PROVIDER;
        return this.createConfiguration(name, event, providerResolver);
    }

    public ConfigurationInstance createConfiguration(String name, Event event, ValueResolver<ConnectionProvider> connectionProviderResolver) throws MuleException {
        Optional<ConnectionProvider> connectionProvider = Optional.ofNullable(connectionProviderResolver.resolve(event));
        T configValue = this.createConfigurationInstance(name, event);
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue, MuleExtensionUtils.createInterceptors((EnrichableModel)this.configurationModel), connectionProvider);
    }

    public ConfigurationInstance createConfiguration(String name, ResolverSetResult resolverSetResult, Optional<ConnectionProvider> connectionProvider) throws MuleException {
        T configValue = this.createConfigurationInstance(name, resolverSetResult);
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue, MuleExtensionUtils.createInterceptors((EnrichableModel)this.configurationModel), connectionProvider);
    }

    private T createConfigurationInstance(String name, ResolverSetResult resolverSetResult) throws MuleException {
        Object config = this.configurationObjectBuilder.build(resolverSetResult);
        MuleExtensionUtils.injectConfigName((EnrichableModel)this.configurationModel, config, name);
        return config;
    }

    private T createConfigurationInstance(String name, Event event) throws MuleException {
        Object config = this.configurationObjectBuilder.build(event);
        MuleExtensionUtils.injectConfigName((EnrichableModel)this.configurationModel, config, name);
        return config;
    }
}

