/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.documentation;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.resources.documentation.ExtensionDescriptionsSerializer;
import org.mule.runtime.module.extension.internal.resources.documentation.XmlExtensionDocumentation;
import org.mule.runtime.module.extension.internal.resources.documentation.XmlExtensionElementDocumentation;
import org.mule.runtime.module.extension.internal.resources.documentation.XmlExtensionParameterDocumentation;

public class ExtensionDocumentationResourceGenerator
implements GeneratedResourceFactory {
    private static final ExtensionDescriptionsSerializer serializer = new ExtensionDescriptionsSerializer();

    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        ExtensionDocumenterWalker walker = new ExtensionDocumenterWalker();
        walker.walk(extensionModel);
        String documenter = serializer.serialize(walker.getDocumenter(extensionModel));
        return Optional.of(new GeneratedResource(serializer.getFileName(extensionModel.getName()), documenter.getBytes()));
    }

    private class ExtensionDocumenterWalker
    extends ExtensionWalker {
        ImmutableList.Builder<XmlExtensionElementDocumentation> elements = ImmutableList.builder();

        private ExtensionDocumenterWalker() {
        }

        protected void onConfiguration(ConfigurationModel model) {
            this.createParameterizedElement((ParameterizedModel)model);
        }

        protected void onOperation(HasOperationModels owner, OperationModel model) {
            this.createParameterizedElement((ParameterizedModel)model);
        }

        protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
            this.createParameterizedElement((ParameterizedModel)model);
        }

        protected void onSource(HasSourceModels owner, SourceModel model) {
            this.createParameterizedElement((ParameterizedModel)model);
        }

        private void createParameterizedElement(ParameterizedModel model) {
            XmlExtensionElementDocumentation element = new XmlExtensionElementDocumentation();
            element.setName(model.getName());
            element.setDescription(model.getDescription());
            element.setParameters(model.getAllParameterModels().stream().map(p -> new XmlExtensionParameterDocumentation(p.getName(), p.getDescription())).collect(Collectors.toList()));
            this.elements.add((Object)element);
        }

        private XmlExtensionDocumentation getDocumenter(ExtensionModel model) {
            XmlExtensionDocumentation documenter = new XmlExtensionDocumentation();
            XmlExtensionElementDocumentation element = new XmlExtensionElementDocumentation();
            element.setName(model.getName());
            element.setDescription(model.getDescription());
            element.setParameters(Collections.emptyList());
            this.elements.add((Object)element);
            documenter.setElements((List<XmlExtensionElementDocumentation>)this.elements.build());
            return documenter;
        }
    }
}

