/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.time.Time;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.api.persistence.manifest.ExtensionManifestXmlSerializer;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.config.ExtensionConfig;
import org.mule.runtime.module.extension.internal.manager.ConfigurationExpirationMonitor;
import org.mule.runtime.module.extension.internal.manager.DefaultConfigurationExpirationMonitor;
import org.mule.runtime.module.extension.internal.manager.ExtensionErrorsRegistrant;
import org.mule.runtime.module.extension.internal.manager.ExtensionRegistry;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.exception.TooManyConfigsException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExtensionManager
implements ExtensionManager,
MuleContextAware,
Initialisable,
Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionManager.class);
    private final ImplicitConfigurationProviderFactory implicitConfigurationProviderFactory = new DefaultImplicitConfigurationProviderFactory();
    private MuleContext muleContext;
    private ExtensionRegistry extensionRegistry;
    private ConfigurationExpirationMonitor configurationExpirationMonitor;
    private ExtensionErrorsRegistrant extensionErrorsRegistrant;

    public void initialise() throws InitialisationException {
        this.extensionRegistry = new ExtensionRegistry(this.muleContext.getRegistry());
        this.extensionErrorsRegistrant = new ExtensionErrorsRegistrant(this.muleContext.getErrorTypeRepository(), this.muleContext.getErrorTypeLocator());
    }

    public void start() throws MuleException {
        this.configurationExpirationMonitor = this.newConfigurationExpirationMonitor();
        this.configurationExpirationMonitor.beginMonitoring();
    }

    public void stop() throws MuleException {
        this.configurationExpirationMonitor.stopMonitoring();
    }

    public void registerExtension(ExtensionModel extensionModel) {
        String extensionName = extensionModel.getName();
        String extensionVersion = extensionModel.getVersion();
        String extensionVendor = extensionModel.getVendor();
        LOGGER.info("Registering extension {} (version: {} vendor: {} )", new Object[]{extensionName, extensionVersion, extensionVendor});
        if (this.extensionRegistry.containsExtension(extensionName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("An extension of name '{}' (version: {} vendor {}) is already registered. Skipping...", new Object[]{extensionName, extensionVersion, extensionVendor});
            }
        } else {
            ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(extensionModel), () -> {
                this.extensionRegistry.registerExtension(extensionName, extensionModel);
                this.extensionErrorsRegistrant.registerErrors(extensionModel);
            });
        }
    }

    public void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.extensionRegistry.registerConfigurationProvider(configurationProvider);
    }

    public ConfigurationInstance getConfiguration(String configurationProviderName, Event muleEvent) {
        return this.getConfigurationProvider(configurationProviderName).map(provider -> provider.get((Object)muleEvent)).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered configurationProvider under name '%s'", configurationProviderName)));
    }

    public ConfigurationInstance getConfiguration(ExtensionModel extensionModel, Event muleEvent) {
        Optional<ConfigurationProvider> provider = this.getConfigurationProvider(extensionModel);
        if (provider.isPresent()) {
            return provider.get().get((Object)muleEvent);
        }
        this.createImplicitConfiguration(extensionModel, muleEvent);
        return this.getConfiguration(extensionModel, muleEvent);
    }

    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel) {
        List<ConfigurationProvider> providers = this.extensionRegistry.getConfigurationProviders(extensionModel);
        int matches = providers.size();
        if (matches == 1) {
            return Optional.of(providers.get(0));
        }
        if (matches > 1) {
            throw new TooManyConfigsException("Too many configs found", extensionModel, matches);
        }
        return Optional.empty();
    }

    public Optional<ConfigurationProvider> getConfigurationProvider(String configurationProviderName) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)configurationProviderName) ? 1 : 0) != 0, (String)"cannot get configuration from a blank provider name");
        return this.extensionRegistry.getConfigurationProvider(configurationProviderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImplicitConfiguration(ExtensionModel extensionModel, Event muleEvent) {
        ExtensionModel extensionModel2 = extensionModel;
        synchronized (extensionModel2) {
            if (this.extensionRegistry.getConfigurationProviders(extensionModel).isEmpty()) {
                this.registerConfigurationProvider(this.implicitConfigurationProviderFactory.createImplicitConfigurationProvider(extensionModel, muleEvent, this.muleContext));
            }
        }
    }

    public Set<ExtensionModel> getExtensions() {
        return this.extensionRegistry.getExtensions();
    }

    public Optional<ExtensionModel> getExtension(String extensionName) {
        return this.extensionRegistry.getExtension(extensionName);
    }

    private ConfigurationExpirationMonitor newConfigurationExpirationMonitor() {
        Time freq = this.getConfigurationExpirationFrequency();
        return DefaultConfigurationExpirationMonitor.Builder.newBuilder(this.extensionRegistry, this.muleContext).runEvery(freq.getTime(), freq.getUnit()).onExpired((key, object) -> this.disposeConfiguration((String)key, (ConfigurationInstance)object)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtensionManifest parseExtensionManifestXml(URL manifestUrl) {
        try (InputStream manifestStream = manifestUrl.openStream();){
            ExtensionManifest extensionManifest = new ExtensionManifestXmlSerializer().deserialize(IOUtils.toString((InputStream)manifestStream));
            return extensionManifest;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not read extension manifest on plugin " + manifestUrl.toString())), (Throwable)e);
        }
    }

    private void disposeConfiguration(String key, ConfigurationInstance configuration) {
        try {
            LifecycleUtils.stopIfNeeded((Object)configuration);
            LifecycleUtils.disposeIfNeeded((Object)configuration, (Logger)LOGGER);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Could not dispose expired dynamic config of key '%s' and type %s", key, configuration.getClass().getName()), (Throwable)e);
        }
    }

    private Time getConfigurationExpirationFrequency() {
        ExtensionConfig extensionConfig = (ExtensionConfig)this.muleContext.getConfiguration().getExtension(ExtensionConfig.class);
        Time defaultFreq = new Time(5L, TimeUnit.MINUTES);
        if (extensionConfig != null) {
            return extensionConfig.getDynamicConfigExpirationFrequency().orElse(defaultFreq);
        }
        return defaultFreq;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

