/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class TypeAwareConfigurationFactory
implements ConfigurationFactory {
    private final Class<?> configurationType;
    private final ClassLoader extensionClassLoader;

    TypeAwareConfigurationFactory(Class<?> configurationType, ClassLoader extensionClassLoader) {
        Preconditions.checkArgument((configurationType != null ? 1 : 0) != 0, (String)"configuration type cannot be null");
        Preconditions.checkArgument((extensionClassLoader != null ? 1 : 0) != 0, (String)"extensionClassLoader type cannot be null");
        IntrospectionUtils.checkInstantiable(configurationType);
        this.configurationType = configurationType;
        this.extensionClassLoader = extensionClassLoader;
    }

    public Object newInstance() {
        try {
            return ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, this.configurationType::newInstance);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not instantiate configuration of type " + this.configurationType.getName())), (Throwable)e);
        }
    }

    public Class<?> getObjectType() {
        return this.configurationType;
    }
}

