/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.ExtensionOf;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.operation.InterceptingCallback;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.JavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExtendingOperationModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.InterceptingModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.OperationExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithOperationContainers;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class OperationModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String OPERATION = "Operation";
    private final Map<MethodElement, OperationDeclarer> operationDeclarers = new HashMap<MethodElement, OperationDeclarer>();

    OperationModelLoaderDelegate(JavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, WithOperationContainers operationContainers) {
        operationContainers.getOperationContainers().forEach(operationContainer -> this.declareOperations(extensionDeclarer, declarer, (OperationContainerElement)operationContainer));
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, OperationContainerElement operationsContainer) {
        this.declareOperations(extensionDeclarer, declarer, operationsContainer.getDeclaringClass(), operationsContainer.getOperations(), true);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, Class<?> methodOwnerClass, List<MethodElement> operations, boolean supportsConfig) {
        for (MethodElement operationMethod : operations) {
            Class declaringClass = methodOwnerClass != null ? methodOwnerClass : operationMethod.getDeclaringClass();
            this.checkOperationIsNotAnExtension(declaringClass);
            Method method = operationMethod.getMethod();
            Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(operationMethod);
            Optional<ExtensionParameter> connectionParameter = this.loader.getConnectionParameter(operationMethod);
            if (this.loader.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter)) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", method.getName()));
            }
            HasOperationDeclarer actualDeclarer = (HasOperationDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)declarer, configParameter, connectionParameter);
            if (this.operationDeclarers.containsKey(operationMethod)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(operationMethod));
                continue;
            }
            OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(operationMethod.getAlias()).withModelProperty((ModelProperty)new ImplementingMethodModelProperty(method))).withModelProperty((ModelProperty)new OperationExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass, method)));
            this.loader.addExceptionEnricher(operationMethod, (HasModelProperties)operation);
            this.processOperationConnectivity(operation, operationMethod);
            if (!this.processNonBlockingOperation(operation, operationMethod)) {
                operation.blocking(true).withOutput().ofType(IntrospectionUtils.getMethodReturnType(method, this.loader.getTypeLoader()));
                operation.withOutputAttributes().ofType(IntrospectionUtils.getMethodReturnAttributesType(method, this.loader.getTypeLoader()));
                this.processInterceptingOperation(operationMethod, operation);
                this.addPagedOperationModelProperty(operationMethod, operation, supportsConfig);
            }
            this.addExecutionType(operation, operationMethod);
            this.loader.declareMethodBasedParameters((ParameterizedDeclarer)operation, operationMethod.getParameters(), new ParameterDeclarationContext(OPERATION, (NamedDeclaration)operation.getDeclaration()));
            this.calculateExtendedTypes(declaringClass, method, operation);
            this.operationDeclarers.put(operationMethod, operation);
        }
    }

    private void processOperationConnectivity(OperationDeclarer operation, MethodElement operationMethod) {
        List<ExtensionParameter> connectionParameters = operationMethod.getParametersAnnotatedWith(Connection.class);
        if (connectionParameters.isEmpty()) {
            ((OperationDeclarer)operation.requiresConnection(false)).transactional(false);
        } else if (connectionParameters.size() == 1) {
            ExtensionParameter connectionParameter = connectionParameters.get(0);
            ((OperationDeclarer)((OperationDeclarer)operation.requiresConnection(true)).transactional(TransactionalConnection.class.isAssignableFrom(connectionParameter.getType().getDeclaringClass()))).withModelProperty((ModelProperty)new ConnectivityModelProperty(connectionParameter.getType().getDeclaringClass()));
        } else if (connectionParameters.size() > 1) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' defines %d parameters annotated with @%s. Only one is allowed", operationMethod.getAlias(), connectionParameters.size(), Connection.class.getSimpleName()));
        }
    }

    private boolean processNonBlockingOperation(OperationDeclarer operation, MethodElement operationMethod) {
        List callbackParameters = operationMethod.getParameters().stream().filter(p -> CompletionCallback.class.equals((Object)p.getType().getDeclaringClass())).collect(Collectors.toList());
        if (callbackParameters.isEmpty()) {
            return false;
        }
        if (callbackParameters.size() > 1) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' defines more than one %s parameters. Only one is allowed", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        }
        if (!IntrospectionUtils.isVoid(operationMethod.getMethod())) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' has a parameter of type %s but is not void. Non-blocking operations have to be declared as void and the return type provided through the callback", operationMethod.getAlias(), CompletionCallback.class.getSimpleName()));
        }
        ExtensionParameter callbackParameter = (ExtensionParameter)callbackParameters.get(0);
        Parameter methodParameter = (Parameter)callbackParameter.getDeclaringElement();
        List<MetadataType> genericTypes = IntrospectionUtils.getGenerics(methodParameter.getParameterizedType(), this.loader.getTypeLoader());
        if (genericTypes.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Generics are mandatory on the %s parameter of Operation '%s'", CompletionCallback.class.getSimpleName(), operationMethod.getAlias()));
        }
        operation.withOutput().ofType(genericTypes.get(0));
        operation.withOutputAttributes().ofType(genericTypes.get(1));
        operation.blocking(false);
        return true;
    }

    private void addExecutionType(OperationDeclarer operationDeclarer, MethodElement operationMethod) {
        operationMethod.getAnnotation(Execution.class).ifPresent(a -> operationDeclarer.withExecutionType(a.value()));
    }

    private void processInterceptingOperation(MethodElement operationMethod, OperationDeclarer operation) {
        if (InterceptingCallback.class.isAssignableFrom(operationMethod.getReturnType())) {
            operation.withModelProperty((ModelProperty)new InterceptingModelProperty());
        }
    }

    private void checkOperationIsNotAnExtension(Class<?> operationType) {
        if (operationType.isAssignableFrom(this.getExtensionType()) || this.getExtensionType().isAssignableFrom(operationType)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation class '%s' cannot be the same class (nor a derivative) of the extension class '%s", operationType.getName(), this.getExtensionType().getName()));
        }
    }

    private void calculateExtendedTypes(Class<?> actingClass, Method method, OperationDeclarer operation) {
        ExtensionOf extensionOf = method.getAnnotation(ExtensionOf.class);
        if (extensionOf == null) {
            extensionOf = actingClass.getAnnotation(ExtensionOf.class);
        }
        if (extensionOf != null) {
            operation.withModelProperty(new ExtendingOperationModelProperty(extensionOf.value()));
        } else if (this.isExtensible()) {
            operation.withModelProperty(new ExtendingOperationModelProperty(this.getExtensionType()));
        }
    }

    private void addPagedOperationModelProperty(MethodElement operationMethod, OperationDeclarer operation, boolean supportsConfig) {
        if (PagingProvider.class.isAssignableFrom(operationMethod.getReturnType())) {
            if (!supportsConfig) {
                throw new IllegalOperationModelDefinitionException(String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", operationMethod.getName()));
            }
            operation.withModelProperty((ModelProperty)new PagedOperationModelProperty());
            operation.requiresConnection(true);
        }
    }

    private boolean isExtensible() {
        return this.getExtensionType().getAnnotation(Extensible.class) != null;
    }
}

