/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.TypedDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.core.internal.metadata.DefaultMetadataResolverFactory;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverFactory;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.internal.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.internal.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.metadata.MetadataScopeAdapter;
import org.mule.runtime.module.extension.internal.metadata.QueryMetadataResolverFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class DynamicMetadataDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private Class<?> extensionType;
    private ClassTypeLoader typeLoader;

    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        Optional<ImplementingTypeModelProperty> implementingType = this.extractExtensionType((BaseDeclaration<? extends BaseDeclaration>)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        if (implementingType.isPresent()) {
            this.extensionType = implementingType.get().getType();
            this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(Thread.currentThread().getContextClassLoader());
            new IdempotentDeclarationWalker(){

                public void onSource(SourceDeclaration declaration) {
                    DynamicMetadataDeclarationEnricher.this.enrichSourceMetadata(declaration);
                }

                public void onOperation(OperationDeclaration declaration) {
                    DynamicMetadataDeclarationEnricher.this.enrichOperationMetadata(declaration);
                }

                protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                    DynamicMetadataDeclarationEnricher.this.enrichParameter(declaration);
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        }
    }

    private void enrichParameter(ParameterDeclaration declaration) {
        Optional<AnnotatedElement> annotatedElement = IntrospectionUtils.getAnnotatedElement(declaration);
        if (annotatedElement.isPresent()) {
            this.parseMetadataAnnotations(annotatedElement.get(), (BaseDeclaration)declaration);
        }
    }

    private void enrichSourceMetadata(SourceDeclaration declaration) {
        declaration.getModelProperty(ImplementingTypeModelProperty.class).ifPresent(prop -> {
            Class<?> sourceType = prop.getType();
            MetadataScopeAdapter metadataScope = new MetadataScopeAdapter(this.extensionType, sourceType);
            this.declareMetadataResolverFactory((ComponentDeclaration<? extends ComponentDeclaration>)declaration, metadataScope);
        });
    }

    private void enrichOperationMetadata(OperationDeclaration declaration) {
        declaration.getModelProperty(ImplementingMethodModelProperty.class).ifPresent(prop -> {
            Method method = prop.getMethod();
            if (method.isAnnotationPresent(Query.class)) {
                this.enrichWithDsql(declaration, method);
            } else {
                MetadataScopeAdapter metadataScope = new MetadataScopeAdapter(this.extensionType, method, declaration);
                this.declareMetadataResolverFactory((ComponentDeclaration<? extends ComponentDeclaration>)declaration, metadataScope);
            }
        });
    }

    private void declareMetadataResolverFactory(ComponentDeclaration<? extends ComponentDeclaration> declaration, MetadataScopeAdapter metadataScope) {
        MetadataResolverFactory metadataResolverFactory = this.getMetadataResolverFactory(metadataScope);
        declaration.addModelProperty((ModelProperty)new MetadataResolverFactoryModelProperty(metadataResolverFactory));
        this.declareMetadataKeyId(declaration);
        this.declareOutputResolvers(declaration, metadataScope);
        this.declareInputResolvers(declaration, metadataScope);
    }

    private void enrichWithDsql(OperationDeclaration declaration, Method method) {
        Query query = method.getAnnotation(Query.class);
        declaration.addModelProperty((ModelProperty)new MetadataResolverFactoryModelProperty(new QueryMetadataResolverFactory(query.nativeOutputResolver(), query.entityResolver())));
        this.addQueryModelProperties(declaration, query);
        this.declareDynamicType((TypedDeclaration)declaration.getOutput());
        this.declareMetadataKeyId((ComponentDeclaration<? extends ComponentDeclaration>)declaration);
    }

    private void addQueryModelProperties(OperationDeclaration declaration, Query query) {
        ParameterDeclaration parameterDeclaration = declaration.getAllParameters().stream().filter(p -> p.getModelProperty(ImplementingParameterModelProperty.class).isPresent()).filter(p -> ((ImplementingParameterModelProperty)p.getModelProperty(ImplementingParameterModelProperty.class).get()).getParameter().isAnnotationPresent(MetadataKeyId.class)).findFirst().orElseThrow(() -> new IllegalParameterModelDefinitionException("Query operation must have a parameter annotated with @MetadataKeyId"));
        parameterDeclaration.addModelProperty((ModelProperty)new QueryParameterModelProperty(query.translator()));
        parameterDeclaration.setLayoutModel(LayoutModel.builderFrom((LayoutModel)parameterDeclaration.getLayoutModel()).asQuery().build());
    }

    private MetadataResolverFactory getMetadataResolverFactory(MetadataScopeAdapter scope) {
        return scope.isCustomScope() ? new DefaultMetadataResolverFactory(scope.getKeysResolver(), scope.getInputResolvers(), scope.getOutputResolver(), scope.getAttributesResolver()) : new NullMetadataResolverFactory();
    }

    private void declareInputResolvers(ComponentDeclaration<?> declaration, MetadataScopeAdapter metadataScope) {
        if (metadataScope.hasInputResolvers()) {
            Set<String> dynamicParameters = metadataScope.getInputResolvers().keySet();
            declaration.getAllParameters().stream().filter(p -> dynamicParameters.contains(p.getName())).forEach(this::declareDynamicType);
        }
    }

    private void declareOutputResolvers(ComponentDeclaration<?> declaration, MetadataScopeAdapter metadataScope) {
        if (metadataScope.hasOutputResolver()) {
            this.declareDynamicType((TypedDeclaration)declaration.getOutput());
        }
        if (metadataScope.hasAttributesResolver()) {
            this.declareDynamicType((TypedDeclaration)declaration.getOutputAttributes());
        }
    }

    private void declareDynamicType(TypedDeclaration component) {
        component.setType(component.getType(), true);
    }

    private void declareMetadataKeyId(ComponentDeclaration<? extends ComponentDeclaration> component) {
        this.getMetadataKeyModelProperty(component).ifPresent(property -> {
            ComponentDeclaration cfr_ignored_0 = (ComponentDeclaration)component.addModelProperty((ModelProperty)property);
        });
    }

    private Optional<MetadataKeyIdModelProperty> getMetadataKeyModelProperty(ComponentDeclaration<? extends ComponentDeclaration> component) {
        Optional<MetadataKeyIdModelProperty> keyId = this.findMetadataKeyIdInGroups(component);
        return keyId.isPresent() ? keyId : this.findMetadataKeyIdInParameters(component);
    }

    private Optional<MetadataKeyIdModelProperty> findMetadataKeyIdInGroups(ComponentDeclaration<? extends ComponentDeclaration> component) {
        return component.getParameterGroups().stream().map(group -> group.getModelProperty(ParameterGroupModelProperty.class).orElse(null)).filter(group -> group != null).filter(group -> group.getDescriptor().getContainer().getAnnotation(MetadataKeyId.class) != null).map(group -> new MetadataKeyIdModelProperty(this.typeLoader.load((Type)group.getDescriptor().getType().getDeclaringClass()), group.getDescriptor().getName())).findFirst();
    }

    private Optional<MetadataKeyIdModelProperty> findMetadataKeyIdInParameters(ComponentDeclaration<? extends ComponentDeclaration> component) {
        return component.getParameterGroups().stream().flatMap(g -> g.getParameters().stream()).filter(p -> IntrospectionUtils.getAnnotatedElement(p).map(element -> element.isAnnotationPresent(MetadataKeyId.class)).orElse(false)).map(p -> new MetadataKeyIdModelProperty(p.getType(), p.getName())).findFirst();
    }

    private void parseMetadataAnnotations(AnnotatedElement element, BaseDeclaration baseDeclaration) {
        if (element.isAnnotationPresent(MetadataKeyId.class)) {
            baseDeclaration.addModelProperty((ModelProperty)new MetadataKeyPartModelProperty(1));
        }
        if (element.isAnnotationPresent(MetadataKeyPart.class)) {
            MetadataKeyPart metadataKeyPart = element.getAnnotation(MetadataKeyPart.class);
            baseDeclaration.addModelProperty((ModelProperty)new MetadataKeyPartModelProperty(metadataKeyPart.order()));
        }
    }
}

