/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.MessageTransformer;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.exception.MessagingException;

public class TypeSafeTransformer {
    private MuleContext muleContext;

    TypeSafeTransformer(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Object transform(Object value, DataType valueDataType, DataType expectedDataType, Event event) throws MessagingException, MessageTransformerException, TransformerException {
        if (value != null) {
            Transformer transformer;
            try {
                transformer = this.muleContext.getRegistry().lookupTransformer(valueDataType, expectedDataType);
            }
            catch (TransformerException e) {
                throw new MessagingException(I18nMessageFactory.createStaticMessage((String)String.format("The value '%s' of type %s could not be transformed to the desired type %s", value.toString(), expectedDataType.getType().getName(), value.getClass().getName())), event, (Throwable)e);
            }
            Object result = transformer instanceof MessageTransformer ? ((MessageTransformer)transformer).transform(value, event) : transformer.transform(value);
            return result;
        }
        return null;
    }
}

